package com.mmc.tmj.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * @Author lcz
 * @Date 2022/5/30 14:53
 * @Version 1.0
 * @description
 */
@Slf4j
public class UTF8Util {

    public static String decode2Utf8(String originStr) {
        String result = null;
        if (StringUtils.isNotEmpty(originStr)) {
            try {
                result = URLDecoder.decode(originStr, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
        }
        return result;
    }

    public static String encode2Utf8(String originStr) {
        String result = null;
        if (StringUtils.isNotEmpty(originStr)) {
            try {
                result = URLEncoder.encode(originStr, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
        }
        return result;
    }

}
