package com.mmc.tmj.service.track.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mmc.tmj.entity.database.TrackDo;
import com.mmc.tmj.entity.other.DataObj;
import com.mmc.tmj.entity.other.TaskDataParam;
import com.mmc.tmj.entity.param.ApiDataParam;
import com.mmc.tmj.entity.param.TrackWebDto;
import com.mmc.tmj.mapper.TrackRepository;
import com.mmc.tmj.service.track.TrackService;
import com.mmc.tmj.utils.BeanTransFormUtil;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/**
 * @Author lcz
 * @Date 2022/5/17 17:49
 * @Version 1.0
 * @description
 */
@Service
public class TrackServiceImpl implements TrackService {
    @Autowired
    private TrackRepository trackRepository;
    @Autowired
    private EntityManager entityManager;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${mmc.tmj.restUrl}")
    private String restUrl;

    @Value("${mmc.tmj.login}")
    private String login;

    @Value("${mmc.tmj.groundData3}")
    private String groundData3;

    @Value("${mmc.tmj.groundData}")
    private String groundData;

    @Value("${mmc.tmj.flyData}")
    private String flyData;

    @Value("${mmc.tmj.username}")
    private String username;

    @Value("${mmc.tmj.password}")
    private String password;


    @Override
    public void create(TrackWebDto trackWebDto) {
        trackRepository.findById(trackWebDto.getId()).ifPresent(is->{
            throw new IllegalArgumentException("数据已存在，请重新操作");
        });
        trackRepository.save(BeanTransFormUtil.transTrackDoByTrackWebDto(trackWebDto));
    }

    @Override
    public DataObj getAircraftFlightSortieData(TaskDataParam readValue) {
        String tableName = "sum_nav_"+readValue.getHashID();
        String sql = "select data from "+tableName+"where flight_sort in "+readValue.getFlightSorties();
        DataObj dataObj = new DataObj();
        try{
            dataObj.setData(entityManager.createNativeQuery(sql).getSingleResult());
        }catch (Exception e){
            dataObj.setData("没有相关数据");
        }
        return dataObj;
    }

    @Override
    public String getAircraftData(String deviceHardId, String appid) {
        Map<String, String> login = login();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("mmc-identity",login.get("mmc-identity"));
        httpHeaders.set("FLYINGSESSIONID",login.get("FLYINGSESSIONID"));
        httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String,String> param = new LinkedMultiValueMap<>();
        param.add("deviceHardId",deviceHardId);
        param.add("appid",appid);
        HttpEntity<MultiValueMap<String,String>> entity = new HttpEntity<>(param,httpHeaders);
        String url = restUrl+flyData.replace("{deviceHardId}",deviceHardId).replace("{appid}",appid);
        return restTemplate.exchange(url, HttpMethod.GET,entity,String.class).getBody();
    }

    @Override
    public String getGroundStationByIdData(String flightSortieInfo, HttpServletRequest request) {
        //Map<String, String> login = login();
        HttpHeaders httpHeaders = new HttpHeaders();
        //httpHeaders.set("mmc-identity",login.get("mmc-identity"));
        httpHeaders.set("token",request.getHeader("token"));
        httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String,String> param = new LinkedMultiValueMap<>();
        param.add("flightSortieInfo",flightSortieInfo);
        HttpEntity<MultiValueMap<String,String>> entity = new HttpEntity<>(param,httpHeaders);
        String url = restUrl+groundData;
        return restTemplate.postForEntity(url,entity,String.class).getBody();
    }

    @Override
    public String getGroundStationData(Map<String, String> map,HttpServletRequest request) {
        //Map<String, String> login = login();
        HttpHeaders httpHeaders = new HttpHeaders();
        //httpHeaders.set("mmc-identity",login.get("mmc-identity"));
        httpHeaders.set("token",request.getHeader("token"));
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        ApiDataParam apiDataParam = new ApiDataParam();
        apiDataParam.setStart(map.get("start"));
        apiDataParam.setEnd(map.get("end"));
        apiDataParam.setHashID(map.get("hashID"));
        HttpEntity<Object> entity = new HttpEntity<>(JSONObject.toJSONString(apiDataParam),httpHeaders);
        String url = restUrl+groundData3;
        return restTemplate.exchange(url,HttpMethod.POST,entity,String.class).getBody();
    }

    public Map<String, String> login() {
        // 请求头设置,x-www-form-urlencoded格式的数据
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        // 提交参数设置
        MultiValueMap<String, String> map = new LinkedMultiValueMap<>();
        map.add("username", username);
        map.add("password", password);
        // 组装请求体
        HttpEntity<MultiValueMap<String, String>> request = new HttpEntity<>(map, headers);
        // 发送post请求，并打印结果，以String类型接收响应结果JSON字符串
        String result =
            restTemplate.postForObject(
                restUrl+login,
                request,
                String.class);
        DataObj data = JSON.parseObject(result, DataObj.class);
        return (Map<String, String>) data.getData();
    }
}
