package com.mmc.tmj.service.device.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mmc.tmj.entity.database.DeviceList;
import com.mmc.tmj.entity.other.DataObj;
import com.mmc.tmj.entity.other.LoginTokenInfo;
import com.mmc.tmj.mapper.DeviceRepository;
import com.mmc.tmj.mapper.TaskRepository;
import com.mmc.tmj.service.device.DeviceService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;

import lombok.SneakyThrows;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/**
 * @Author lcz
 * @Date 2022/5/12 17:15
 * @Version 1.0
 * @description
 */
@Service
public class DeviceServiceImpl implements DeviceService {

    @Value("${mmc.tmj-v1.url}")
    private String TMJ_V1_URl;

    private static String DEVICE_CHILD_PLATFORM_PATH = "devicecentersystemserver/";

    @Resource
    private RestTemplate restTemplate;

    @Resource
    private ObjectMapper objectMapper;
    @Resource
    private TaskRepository taskRepository;

    @Autowired
    private DeviceRepository deviceRepository;

    @SneakyThrows
    @Override
    public DataObj getDeviceSelect(LoginTokenInfo loginTokenInfo,Integer organizationId) {
        /*String url = TMJ_V1_URl+DEVICE_CHILD_PLATFORM_PATH+"device/devicesByCompanyId?companyId="+organizationId;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        httpHeaders.set("mmc-identity",loginTokenInfo.getMmc_identity());
        httpHeaders.set("FLYINGSESSIONID",loginTokenInfo.getFLYINGSESSIONID());
        HttpEntity<Object> objectHttpEntity = new HttpEntity<>(httpHeaders);
        ResponseEntity<String> exchange = restTemplate.exchange(url, HttpMethod.GET,
            objectHttpEntity, String.class);
        String body = exchange.getBody();*/
        return new DataObj<List>("200","ok", deviceRepository.devicesByCompanyId(organizationId));
    }

    @Override
    public Integer deviceHaveTask(Integer id) {
        return taskRepository.deviceHaveTask(id);
    }

    @Override
    public String updateDeviceName(LoginTokenInfo token, String deviceHardId, String deviceName) {
        /*String url = TMJ_V1_URl+DEVICE_CHILD_PLATFORM_PATH+"/datareport/updateDeviceName";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        httpHeaders.set("mmc-identity",token.getMmc_identity());
        httpHeaders.set("FLYINGSESSIONID",token.getFLYINGSESSIONID());
        MultiValueMap<String,Object> map = new LinkedMultiValueMap<>();
        map.add("deviceHardId",deviceHardId);
        map.add("deviceName",deviceName);
        HttpEntity<MultiValueMap<String, Object>> entity = new HttpEntity<>(map,httpHeaders);
        ResponseEntity<String> stringResponseEntity = restTemplate.postForEntity(url, entity, String.class);*/
        deviceRepository.updateDeviceNameByDeviceHardId(deviceHardId,deviceName);
        return "ok";
    }
}
