package com.mmc.tmj.filter;

import com.alibaba.fastjson.JSONObject;
import com.mmc.tmj.service.login.LoginService;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.stereotype.Component;

/**
 * @Author lcz
 * @Date 2022/5/19 10:24
 * @Version 1.0
 * @description
 */

@Component
@Slf4j
public class LoginFilter implements Filter {

    @Value("${mmc.tmj.whiteList}")
    private List<String> whiteList;
    @Autowired
    private LoginService loginService;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        Filter.super.init(filterConfig);
    }

    @Override
    public void destroy() {
        Filter.super.destroy();
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
        throws IOException, ServletException {
        HttpServletRequest httpServletRequest =(HttpServletRequest) request;
        log.info("httpServletRequest token={}", httpServletRequest.getHeader("token"));
        String requestURI = httpServletRequest.getRequestURI();
        log.info("requestURI={}",requestURI);
        //白名单过滤
        Optional<String> first = whiteList.stream().filter(s -> requestURI.startsWith(s))
            .findFirst();
        if(first.isPresent()){
            chain.doFilter(request,response);
        }else {
            if(loginService.checkLoginInfo(httpServletRequest.getHeader("token"))){
                chain.doFilter(request,response);
            }else {
                log.info("解析token异常");
                return;
            };
        }

    }
}
