package com.mmc.tmj.entity.result;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

/**
 * @Author lcz
 * @Date 2022/5/16 17:55
 * @Version 1.0
 * @description
 */
@Data
@ApiModel(description = "航点详情")
public class RoutePointDetail {
    /** 航点唯一标识，由前端生成 */
    @ApiModelProperty(value = "航点UUID")
    private String uuid;

    @ApiModelProperty(value = "航点纬度", example = "10.03564")
    private double latitude;

    /** 经度，目前单位都是度 */
    @ApiModelProperty(value = "航点经度", example = "10.03564")
    private double longitude;

    /** 海拔高度，可能叫elevation更为准确,目前海拔高度的单位都是米 */
    @ApiModelProperty(value = "航点海拔", example = "10.03564")
    private double altitude;

    /** 偏航角度，目前单位都是度；暂时没有必要拆成值对象 */
    @ApiModelProperty(value = "航点偏航角", example = "10")
    private double yawAngle;

    /** 俯仰角度，目前单位都是度；暂时没有必要拆成值对象 */
    @ApiModelProperty(value = "航点俯仰角", example = "10.03564")
    private double pitchAngle;

    /** 单位m/s */
    @ApiModelProperty(value = "航点速度（m/s）", example = "10.03")
    private double speed;

    /** 航点动作 */
    @ApiModelProperty(value = "动作")
    private List<ActionDetail> actions;
}
