package com.mmc.tmj.entity.other;

import java.util.List;
import lombok.Data;

/**
 * @Author lcz
 * @Date 2022/5/16 15:40
 * @Version 1.0
 * @description
 */
@Data
public class PointFormat {

    /*航点动作数据组*/
    private List<ActionFormat> actions;
    /** 航点高度 */
    private Double alt;
    /** 航点描述 */
    private String describe;
    /** 航点获取途径（用什么方式获取）[0：未知，1：GPS，2：RTK，3：手动，4：点云] */
    private String getStatus;
    /** 云台俯仰角度 */
    private Double gimbalPitch;
    /** 高度模式[相对高度:true */
    private String isRelativeAltitude;
    /** 航点是否显示 */
    private String isShow;
    /*是否使用航线高度 [使用line中的baseAltitude高度：true，使用航点的alt高度:false]*/
    private String isUseWaylineAltitude;

    private Double lat;

    private Double lon;
    /** 飞机偏航角 */
    private Double pitch;
    /** 航点类型 [起始点:1，正常航点（任务点）:2，辅助点:3，终止点:4] */
    private Double pointType;
    /** 飞机偏航时的方向 [顺时针：CLOCKWISE，逆时针：COUNTER_CLOCKWISE，自动：AUTO] */
    private Double turnMode;


}
