package com.mmc.tmj.entity.other;

import lombok.Data;

/**
 * @Author lcz
 * @Date 2022/5/16 15:56
 * @Version 1.0
 * @description
 */
@Data
public class LineFormat {
    /** 航线高度 */
    private Double baseAltitude;
    /** 航线速度 */
    private Double baseSpeed;
    /** 通道速度[如果是杆塔巡检，2塔之间的通道就使用此速度] */
    private String channelSpeed;

    private String coordinates;
    /** 遥控器丢失是否退出航线任务[退出:true，继续任务:false] */
    private String exitMissionOnRCSignalLost;
    /** 航线任务完成后的动作[自动返航：GO_HOME，悬停：NO_ACTION，原地降落：AUTO_LAND 返回航线起始点：GO_FIRST_WAYPOINT ] */
    private String finishedAction;
    /** 云台控制模式[使用航点控制:true，手动控制:false] */
    private String gimbalPitchRotation;
    /** 机头模式[使用航点设置：USING_WAYPOINT_HEADING，沿航线方向：AUTO，手动控制：CONTROL_BY_REMOTE_CONTROLLER] */
    private String headingMode;
    /** 通道速度开关[如果是杆塔巡检 true:2塔之间的通道就使用通道速度 ，false:使用baseSpeed] */
    private String useChannelSpeed;
}
