package com.mmc.tmj.entity.database;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Data;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

/**
 * @Author lcz
 * @Date 2022/5/16 10:17
 * @Version 1.0
 * @description
 */
@Data
@Entity
@Table(name = "route_point")
public class RoutePointDo {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    /** 航点唯一标识，由前端生成 */
    private String uuid;
    /** 纬度,目前单位都是度 */
    private Double latitude;
    /** 纬度,目前单位都是度 */
    private Double longitude;
    /** 海拔高度，可能叫elevation更为准确,目前海拔高度的单位都是米 */
    private Double altitude;
    /** 偏航角度；暂时没有必要拆成值对象 */
    private Double yawAngle;
    /** 俯仰角度；暂时没有必要拆成值对象 */
    private Double pitchAngle;
    /** 航点速度 */
    private Double speed;
    /** 航点动作 */
    @OneToMany(
        cascade = {CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE},
        fetch = FetchType.EAGER,
        orphanRemoval = true)
    @Fetch(FetchMode.SUBSELECT)
    @JoinColumn(name = "point_id")
    private List<ActionDo> actions;


}
