package com.mmc.tmj.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mmc.tmj.entity.other.DataObj;
import com.mmc.tmj.entity.other.TaskDataParam;
import com.mmc.tmj.entity.param.TrackWebDto;
import com.mmc.tmj.entity.result.BaseResponse;
import com.mmc.tmj.service.track.TrackFlightSortieInfoService;
import com.mmc.tmj.service.track.TrackService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.awt.image.RasterFormatException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author lcz
 * @Date 2022/5/12 9:57
 * @Version 1.0
 * @description
 */
@RestController
@RequestMapping(path = "Track")
@Api(tags = "航迹")
@Validated
@Slf4j
public class TrackController {
    /**
     * 获取飞机实时数据1
     *
     * @param deviceHardIds
     * @return
     */
    @Autowired
    private StringRedisTemplate redisUserTemplate;

    @Autowired
    private TrackService trackService;

    @Autowired
    private ObjectMapper objectMapper;

    @Autowired
    private TrackFlightSortieInfoService trackFlightSortieInfoService;

    @PostMapping
    @ApiOperation("接收航轨")
    public void create(TrackWebDto trackWebDto){
        trackService.create(trackWebDto);
    }

    /**
     * 地面站上报数据(关联任务id）
     */
    @SneakyThrows
    @GetMapping("/getAircraftFlightSortieData")
    @ApiOperation("地面站上报数据")
    public BaseResponse getAircraftFlightSortieData(@RequestParam("flightSortieInfo") String flightSortieInfo){
        DataObj dataObj=trackService.getAircraftFlightSortieData(objectMapper.readValue(flightSortieInfo, TaskDataParam.class));
        return BaseResponse.ok(dataObj);
    }
    @GetMapping(value = "/pan")
    @ApiOperation("判断表")
    public BaseResponse getAircraftLatestDataByDeviceHardId(String tableName){
        return BaseResponse.ok(trackFlightSortieInfoService.isExitTable(tableName));
    }

    @GetMapping(value = "/getLatestDataByDeviceHardId")
    @ApiOperation("获取飞机实时数据")
    public BaseResponse<Map<String, String>> getAircraftLatestDataByDeviceHardId(String deviceHardId,String appid){
        Map<String, String> map = new HashMap<>();
        map.put(deviceHardId,redisUserTemplate.opsForValue().get("latest_data_"+appid+"_"+deviceHardId));
        return BaseResponse.ok(null);
    }

    @GetMapping("/getAircraftData")
    // @ApiOperation("获取飞机实时数据")
    public BaseResponse<String> getAircraftData(String deviceHardId,String appid){
        String body=trackService.getAircraftData(deviceHardId,appid);
        return BaseResponse.ok(body);
    }

    @PostMapping("/getGroundStationByIdData")
    // @ApiOperation("地面站上报数据(关联任务id)")
    public BaseResponse<String> getGroundStationByIdData(@RequestParam("flightSortieInfo") String flightSortieInfo,
        HttpServletRequest request){
        String body=trackService.getGroundStationByIdData(flightSortieInfo,request);
        return BaseResponse.ok(body);
    }

    @PostMapping("/getGroundStationData")
    // @ApiOperation("地面站上报数据(不关联任务id)")
    public BaseResponse<String> getGroundStationData(@RequestBody Map<String,String> map,HttpServletRequest request){
        String body=trackService.getGroundStationData(map,request);
        return BaseResponse.ok(body);
    }
}
