package com.mmc.tmj.controller;

import com.mmc.tmj.entity.result.TaskReportDto;
import com.mmc.tmj.service.task.TaskService;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author lcz
 * @Date 2022/5/12 9:56
 * @Version 1.0
 * @description
 */
@Controller
@Api(tags = "任务报告")
@Validated
@Slf4j
public class TaskResportController {
    @Autowired
    private TaskService taskService;

    @Autowired
    private ResourceLoader resourceLoader;

    @Autowired
    private StringRedisTemplate redisUserTemplate;

    @Value("${mmc.tmj.physicalUrl}")
    private String uploadPath;

    //导出模板，代码需要按实际做调整
    @SneakyThrows
    @GetMapping("/taskPointExportToWord")
    @ApiOperation("导出任务报告")
    public void taskPointExportToWord(@RequestParam Integer taskId, HttpServletRequest request, HttpServletResponse response){
        // 1 检查任务状态是否为已完成
        if(taskService.checkTaskStatus(taskId).intValue()==0){
            throw new IllegalArgumentException("导出失败，请检查任务状态是否为已完成");
        };
        // 2 获取导出的模板
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/天目将无人机任务报告模板.docx");
        IXDocReport ixDocReport = XDocReportRegistry.getRegistry()
            .loadReport(resourceAsStream, TemplateEngineKind.Freemarker);
        IContext context = ixDocReport.createContext();
        FieldsMetadata fieldsMetadata = ixDocReport.createFieldsMetadata();
        ixDocReport.createFieldsMetadata();
        context.put("taskId","666");
        context.put("taskName","777");
        context.put("taskDate","888");
        context.put("taskTime","999");
        context.put("deviceHardId","100");
        context.put("remark","200");
        context.put("executePerson","300");
        context.put("reportAddTime","400");

        //图片获取
        InputStream resourceAsStream1 = this.getClass().getResourceAsStream("/imgs/1.png");
        InputStream resourceAsStream2 = this.getClass().getResourceAsStream("/imgs/2.png");
        InputStream resourceAsStream3 = this.getClass().getResourceAsStream("/imgs/3.png");

        context.put("img1",resourceAsStream1);
        context.put("img2",resourceAsStream2);
        context.put("img3",resourceAsStream3);
        fieldsMetadata.addFieldAsImage("img1");
        fieldsMetadata.addFieldAsImage("img2");
        fieldsMetadata.addFieldAsImage("img3");

        log.info("获取模板文件成功");
        // 3 获取导出的用户名称，任务数据
        String username=(String)redisUserTemplate.opsForHash().get("token::allow:hash","1");
        TaskReportDto taskReportDto=taskService.export(taskId);
        Map<String, Object> map= taskService.dataMap(taskReportDto,username);
        // 4 生成导出的模板数据，导出的文件名称
        String reportFile = taskReportDto.getTaskName()+"任务报告.docx";

        // 5 生成word文档，保存数据库对应数据id,名称
        //taskService.saveTaskReportInfo(taskReportDto.getTaskId(),uploadPath+"任务报告.docx");

        // 6 word文档导出浏览器
        response.reset();

        try {
            reportFile = URLEncoder.encode(reportFile,"UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("文件名编码失败", e);
        }
        log.info("文件名编码成功");

        response.setHeader("Content-disposition","attachment; filename=" + reportFile);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/msword");

        try (ServletOutputStream outputStream = response.getOutputStream();){
            ixDocReport.process(context,outputStream);
            //Files.copy(file.toPath(),outputStream);
        } catch (IOException e) {
            e.printStackTrace();
        }
        log.info("报告导出成功");
    }
}
