package com.mmc.tmj.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @Author lcz
 * @Date 2022/5/18 16:23
 * @Version 1.0
 * @description
 */
@Configuration
public class SwaggerConfig implements WebMvcConfigurer {
//    文档按路由分组

    @Value("${mmc.tmj.physicalUrl}")
    private String physicalUrl;

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/files/**").addResourceLocations(physicalUrl);
    }
}
