package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.database.TrackDo;
import com.mmc.tmj.utils.builder.statement.TrackDoStatementTmBuilder;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/18 9:36
 * @Version 1.0
 * @description
 */
public class TrackDoTmBuilder extends TrackDoStatementTmBuilder<TrackDo> {
    public static TrackDoTmBuilder getInstance(){
        return new TrackDoTmBuilder();
    }

    @Override
    public TrackDo getObject() {
        return trackDo;
    }

    @Override
    public TrackDoTmBuilder init(TrackDo object) {
        return this;
    }

    @Override
    public TrackDoTmBuilder init() {
        return this;
    }

    @Override
    public TrackDoTmBuilder buildId(Integer id) {
        Optional.ofNullable(id).ifPresent(inte ->{
            this.trackDo.setId(inte);
        });
        return this;
    }

    @Override
    public TrackDoTmBuilder buildSystemCode(String systemCode) {
        Optional.ofNullable(systemCode).ifPresent(inte ->{
            this.trackDo.setSystemCode(inte);
        });
        return this;
    }

    @Override
    public TrackDoTmBuilder buildDeviceType(String deviceType) {
        Optional.ofNullable(deviceType).ifPresent(inte ->{
            this.trackDo.setDeviceType(inte);
        });
        return this;
    }

    @Override
    public TrackDoTmBuilder buildDeviceHardId(String deviceHardId) {
        Optional.ofNullable(deviceHardId).ifPresent(inte ->{
            this.trackDo.setDeviceHardId(inte);
        });
        return this;
    }

    @Override
    public TrackDoTmBuilder buildFlightSortie(String flightSortie) {
        Optional.ofNullable(flightSortie).ifPresent(inte ->{
            this.trackDo.setFlightSortie(inte);
        });
        return this;
    }

    @Override
    public TrackDoTmBuilder buildData(String data) {
        Optional.ofNullable(data).ifPresent(inte ->{
            this.trackDo.setData(inte);
        });
        return this;
    }

    @Override
    public TrackDoTmBuilder buildTime(Integer time) {
        Optional.ofNullable(time).ifPresent(inte ->{
            this.trackDo.setTime(inte);
        });
        return this;
    }
}
