package com.mmc.tmj.utils.builder.statement.impl;

import cn.afterturn.easypoi.entity.ImageEntity;
import com.mmc.tmj.entity.result.PhotographListVo;
import com.mmc.tmj.utils.builder.statement.TaskReportMapStatementTmBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/18 15:16
 * @Version 1.0
 * @description
 */
public class TaskReportMapTmBuilder extends TaskReportMapStatementTmBuilder<Map<String,Object>> {
    public static TaskReportMapTmBuilder getInstance(){
        return new TaskReportMapTmBuilder();
    }
    @Override
    public Map<String, Object> getObject() {
        return map;
    }

    @Override
    public TaskReportMapTmBuilder init(Map<String, Object> object) {
        map=object;
        return this;
    }

    @Override
    public TaskReportMapTmBuilder init() {
        map=new HashMap<String,Object>();
        return this;
    }

    @Override
    public TaskReportMapTmBuilder buildTaskId(Integer taskId) {
        Optional.ofNullable(taskId).ifPresent(inte ->{
            this.map.put("taskId",inte);
        });
        return this;
    }

    @Override
    public TaskReportMapTmBuilder buildTaskName(String taskName) {
        Optional.ofNullable(taskName).ifPresent(inte ->{
            this.map.put("taskName",inte);
        });
        return this;
    }

    @Override
    public TaskReportMapTmBuilder buildTaskDate(String taskDate) {
        Optional.ofNullable(taskDate).ifPresent(inte ->{
            this.map.put("taskDate",inte);
        });
        return this;
    }

    @Override
    public TaskReportMapTmBuilder buildDeviceHardId(String deviceHardId) {
        Optional.ofNullable(deviceHardId).ifPresent(inte ->{
            this.map.put("deviceHardId",inte);
        });
        return this;
    }

    @Override
    public TaskReportMapTmBuilder buildTaskTime(String taskTime) {
        this.map.put("taskTime",taskTime);
        return this;
    }

    @Override
    public TaskReportMapTmBuilder buildImageList(List<ImageEntity> imageList) {
        this.map.put("imageList",imageList);
        return this;
    }

    @Override
    public TaskReportMapTmBuilder buildExecutePerson(String executePerson) {
        Optional.ofNullable(executePerson).ifPresent(inte ->{
            this.map.put("executePerson",inte);
        });
        return this;
    }

    @Override
    public TaskReportMapTmBuilder buildReportAddTime(String reportAddTime) {
        Optional.ofNullable(reportAddTime).ifPresent(inte ->{
            this.map.put("reportAddTime",inte);
        });
        return this;
    }

    @Override
    public TaskReportMapTmBuilder buildRemark(String remark) {
        Optional.ofNullable(remark).ifPresent(inte ->{
            this.map.put("remark",inte);
        });
        return this;
    }
}
