package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.database.RunProjectDo;
import com.mmc.tmj.utils.builder.statement.RunProjectDoStatementTmBuilder;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/21 15:12
 * @Version 1.0
 * @description
 */
public class RunProjectDoTmBuilder extends RunProjectDoStatementTmBuilder<RunProjectDo> {
    public static RunProjectDoTmBuilder getInstance(){
        return new RunProjectDoTmBuilder();
    }

    @Override
    public RunProjectDo getObject() {
        return runProjectDo;
    }

    @Override
    public RunProjectDoTmBuilder init(RunProjectDo object) {
        runProjectDo=object;
        return this;
    }

    @Override
    public RunProjectDoTmBuilder init() {
        runProjectDo=new RunProjectDo();
        return this;
    }

    @Override
    public RunProjectDoTmBuilder buildId(Integer id) {
        Optional.ofNullable(id).ifPresent(it->{
            runProjectDo.setId(it);
        });
        return this;
    }

    @Override
    public RunProjectDoTmBuilder buildProjectName(String projectName) {
        Optional.ofNullable(projectName).ifPresent(it->{
            runProjectDo.setProjectName(it);
        });
        return this;
    }

    @Override
    public RunProjectDoTmBuilder buildProjectDescript(String projectDescript) {
        Optional.ofNullable(projectDescript).ifPresent(it->{
            runProjectDo.setProjectDescript(it);
        });
        return this;
    }

    @Override
    public RunProjectDoTmBuilder buildProjectAddress(String projectAddress) {
        Optional.ofNullable(projectAddress).ifPresent(it->{
            runProjectDo.setProjectAddress(it);
        });
        return this;
    }

    @Override
    public RunProjectDoTmBuilder buildLatitude(Double latitude) {
        Optional.ofNullable(latitude).ifPresent(it->{
            runProjectDo.setLatitude(it);
        });
        return this;
    }

    @Override
    public RunProjectDoTmBuilder buildLongitude(Double longitude) {
        Optional.ofNullable(longitude).ifPresent(it->{
            runProjectDo.setLongitude(it);
        });
        return this;
    }
}
