package com.mmc.tmj.utils.builder.statement.impl;

import com.mmc.tmj.entity.result.RouteList;
import com.mmc.tmj.utils.builder.statement.RouteListStatementTmBuilder;
import java.util.Optional;

/**
 * @Author lcz
 * @Date 2022/5/17 13:46
 * @Version 1.0
 * @description
 */
public class RouteListTmBuilder extends RouteListStatementTmBuilder<RouteList> {

    public static RouteListTmBuilder getInstance(){
        return new RouteListTmBuilder();
    }

    @Override
    public RouteList getObject() {
        return routeList;
    }

    @Override
    public RouteListTmBuilder init(RouteList object) {
        routeList=object;
        return this;
    }

    @Override
    public RouteListTmBuilder init() {
        routeList=new RouteList();
        return this;
    }

    @Override
    public RouteListTmBuilder buildName(String name) {
        Optional.ofNullable(name).ifPresent(inte ->{
            this.routeList.setName(inte);
        });
        return this;
    }

    @Override
    public RouteListTmBuilder buildDefaultAltitude(Double defaultAltitude) {
        Optional.ofNullable(defaultAltitude).ifPresent(inte ->{
            this.routeList.setDefaultAltitude(inte);
        });
        return this;
    }

    @Override
    public RouteListTmBuilder buildDefaultSpeed(Double defaultSpeed) {
        Optional.ofNullable(defaultSpeed).ifPresent(inte ->{
            this.routeList.setDefaultSpeed(inte);
        });
        return this;
    }

    @Override
    public RouteListTmBuilder buildRemark(String remark) {
        Optional.ofNullable(remark).ifPresent(inte ->{
            this.routeList.setRemark(inte);
        });
        return this;
    }

    @Override
    public RouteListTmBuilder buildId(Integer id) {
        Optional.ofNullable(id).ifPresent(inte ->{
            this.routeList.setId(inte);
        });
        return this;
    }

    @Override
    public RouteListTmBuilder buildNumOfPoint(int numOfPoint) {
        Optional.ofNullable(numOfPoint).ifPresent(inte ->{
            this.routeList.setNumOfPoint(inte);
        });
        return this;
    }

    @Override
    public RouteListTmBuilder buildKmOfRoute(double kmOfRoute) {
        Optional.ofNullable(kmOfRoute).ifPresent(inte ->{
            this.routeList.setKmOfRoute(inte);
        });
        return this;
    }

    @Override
    public RouteListTmBuilder buildExpectTakeMinute(double expectTakeMinute) {
        Optional.ofNullable(expectTakeMinute).ifPresent(inte ->{
            this.routeList.setExpectTakeMinute(inte);
        });
        return this;
    }

    @Override
    public RouteListTmBuilder buildCreateWhen(String createWhen) {
        Optional.ofNullable(createWhen).ifPresent(inte ->{
            this.routeList.setCreateWhen(inte);
        });
        return this;
    }
}
