package com.mmc.tmj.utils.builder.statement;

import com.mmc.tmj.entity.database.ActionDo;
import com.mmc.tmj.entity.database.RoutePointDo;
import com.mmc.tmj.entity.result.ActionDetail;
import com.mmc.tmj.entity.result.RoutePointDetail;
import com.mmc.tmj.utils.builder.TmBuilder;
import java.util.List;


/**
 * @Author lcz
 * @Date 2022/5/9 10:16
 * @Version 1.0
 * @description
 */
public abstract class RoutePointDetailStatementTmBuilder<T> extends TmBuilder<RoutePointDetail> {
    protected RoutePointDetail routePointDetail = new RoutePointDetail();

    @Override
    public abstract RoutePointDetailStatementTmBuilder init(RoutePointDetail object);

    @Override
    public abstract RoutePointDetailStatementTmBuilder init();


    public abstract RoutePointDetailStatementTmBuilder buildUuid(String uuid);

    public abstract RoutePointDetailStatementTmBuilder buildLatitude(Double latitude);

    public abstract RoutePointDetailStatementTmBuilder buildLongitude(Double longitude);

    public abstract RoutePointDetailStatementTmBuilder buildAltitude(Double altitude);

    public abstract RoutePointDetailStatementTmBuilder buildYawAngle(Double yawAngle);

    public abstract RoutePointDetailStatementTmBuilder buildPitchAngle(Double pitchAngle);

    public abstract RoutePointDetailStatementTmBuilder buildSpeed(Double speed);

    public abstract RoutePointDetailStatementTmBuilder buildActions(List<ActionDetail> actions);


}
