package com.mmc.tmj.utils.builder.statement;

import com.mmc.tmj.entity.database.TaskDto;
import com.mmc.tmj.entity.result.PageRespVo;
import com.mmc.tmj.utils.builder.TmBuilder;
import java.util.List;
import org.apache.poi.ss.formula.functions.T;

/**
 * @Author lcz
 * @Date 2022/5/12 11:51
 * @Version 1.0
 * @description
 */
public abstract class PageRespVoStatementTmBuilder<T> extends TmBuilder<PageRespVo<T>> {
    protected PageRespVo<T> pageRespVo = new PageRespVo<T>();

    @Override
    public PageRespVoStatementTmBuilder init(PageRespVo<T> object) {
        pageRespVo = object;
        return this;
    }

    @Override
    public PageRespVoStatementTmBuilder init() {
        return this;
    }
    public abstract PageRespVoStatementTmBuilder buildTotalSize(Long totalSize);

    public abstract PageRespVoStatementTmBuilder buildTotalNum(Integer totalNum);

    public abstract PageRespVoStatementTmBuilder buildNum(Integer num);

    public abstract PageRespVoStatementTmBuilder buildSize(Integer size);

    public abstract PageRespVoStatementTmBuilder buildData(List<T> data);


}
