package com.mmc.tmj.utils;

import com.mmc.tmj.entity.database.TaskDto;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.dsl.ArrayPath;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.CollectionPath;
import com.querydsl.core.types.dsl.ComparablePath;
import com.querydsl.core.types.dsl.DatePath;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.ListPath;
import com.querydsl.core.types.dsl.MapPath;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathInits;
import com.querydsl.core.types.dsl.SetPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.TimePath;
import javax.annotation.Nullable;
import org.apache.poi.ss.formula.functions.T;

/**
 * @Author lcz
 * @Date 2022/5/12 11:19
 * @Version 1.0
 * @description
 */
public class TmjBeanPath extends BeanPath<T> {

    private static TmjBeanPath tmjBeanPath;

    @Override
    public <P extends Path<?>> P add(P path) {
        return super.add(path);
    }

    @Override
    public <A, E> ArrayPath<A, E> createArray(String property, Class<? super A> type) {
        return super.createArray(property, type);
    }

    @Override
    public BooleanPath createBoolean(String property) {
        return super.createBoolean(property);
    }

    @Override
    public <A extends Number & Comparable<?>> NumberPath<A> createNumber(String property,
        Class<? super A> type) {
        //NumberPath<A> number = super.createNumber(property, type);
        return super.add(new TmjNumberPath<A>((Class) type, forProperty(property)));
    }

    @Override
    public <A extends Comparable> ComparablePath<A> createComparable(String property,
        Class<? super A> type) {
        return super.createComparable(property, type);
    }

    @Override
    public <A extends Enum<A>> EnumPath<A> createEnum(String property, Class<A> type) {
        return super.createEnum(property, type);
    }

    @Override
    public <A extends Comparable> DatePath<A> createDate(String property,
        Class<? super A> type) {
        return super.createDate(property, type);
    }

    @Override
    public <A extends Comparable> DateTimePath<A> createDateTime(String property,
        Class<? super A> type) {
        return super.createDateTime(property, type);
    }



    @Override
    public <A> SimplePath<A> createSimple(String property, Class<? super A> type) {
        return super.createSimple(property, type);
    }

    @Override
    public StringPath createString(String property) {
        return super.createString(property);
    }

    @Override
    public <A extends Comparable> TimePath<A> createTime(String property,
        Class<? super A> type) {
        return super.createTime(property, type);
    }

    @Override
    public PathMetadata forProperty(String property) {
        return super.forProperty(property);
    }

    public static TmjBeanPath of(Class type,String variable){
        if (null != tmjBeanPath) {
            if(tmjBeanPath.getType().equals(type) && tmjBeanPath.getMetadata().getElement().equals(variable)){
                return tmjBeanPath;
            }
        }
        tmjBeanPath=new TmjBeanPath(type, new PathMetadata(null, variable, PathType.VARIABLE));
        return tmjBeanPath;
    }

    public TmjBeanPath(Class<? extends T> type, String variable) {
        super(type, variable);
    }

    public TmjBeanPath(Class<? extends T> type, Path<?> parent,
        String property) {
        super(type, parent, property);
    }

    public TmjBeanPath(Class<? extends T> type, PathMetadata metadata) {
        super(type, metadata);
    }

    public TmjBeanPath(Class<? extends T> type, PathMetadata metadata,
        @Nullable PathInits inits) {
        super(type, metadata, inits);
    }
}
