package com.mmc.tmj.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import javax.xml.bind.DatatypeConverter;

public class JWTUtil {
  public static final String X_USER_ID = "x-user-id";
  public static final String TOKEN_PREFIX = "bearer;"; // token前缀

  /** 解析jwt */
  public static Claims parseJWT(String jsonWebToken, String base64Security) {
    try {
      Claims claims =
          Jwts.parser()
              .setSigningKey(DatatypeConverter.parseBase64Binary(base64Security))
              .parseClaimsJws(jsonWebToken)
              .getBody();
      return claims;
    } catch (Exception ex) {
      return null;
    }
  }
}
