package com.mmc.tmj.service.task;

import com.mmc.tmj.entity.database.PhotographDo;
import com.mmc.tmj.entity.param.TaskWebDto;
import com.mmc.tmj.entity.result.PageRespVo;
import com.mmc.tmj.entity.result.TaskInfoVo;
import com.mmc.tmj.entity.result.TaskListVo;
import com.mmc.tmj.entity.result.TaskReportDto;
import com.mmc.tmj.entity.result.TaskSelectVo;
import java.util.List;
import java.util.Map;

/**
 * @Author lcz
 * @Date 2022/5/7 16:44
 * @Version 1.0
 * @description
 */
public interface TaskService {


    boolean createTask(TaskWebDto createDto);

    PageRespVo<TaskListVo> getTaskList(String taskName, String status, int num, int size);

    List<TaskSelectVo> getTaskSelect(String name);

    boolean updateTask(TaskWebDto taskWebDto);

    TaskInfoVo getTaskInfoById(Integer id);

    boolean updateTaskStatus(Integer id,int oldStatus,int newStatus);

    boolean deleteTask(Integer id);

    void savePhotograph(PhotographDo photographDo);

    Integer checkTaskStatus(Integer taskId);

    TaskReportDto export(Integer taskId);

    Map<String, Object> dataMap(TaskReportDto taskReportDto, String username);

    void saveTaskReportInfo(Integer taskId, String s);
}
