package com.mmc.tmj.service.route.assembler;

import com.mmc.tmj.entity.database.RouteDo;
import com.mmc.tmj.entity.other.RouteUploadDto;
import com.mmc.tmj.entity.param.RouteDataDto;
import com.mmc.tmj.mapper.RouteRepository;
import com.mmc.tmj.utils.BeanTransFormUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author lcz
 * @Date 2022/5/16 10:40
 * @Version 1.0
 * @description
 */
@Component
public class RouteAssembler {
    @Autowired
    private RouteRepository routeRepository;


    public RouteDo fromRouteDto(RouteDataDto routeDataDto) {
        RouteDo byName = routeRepository.findByName(routeDataDto.getName());
        if(null != byName){
            return null;
        }
        return BeanTransFormUtil.transRouteDo(routeDataDto);
    }

    public RouteDo fromUpdateRouteDto(RouteDataDto routeDataDto) {
        RouteDo byName = routeRepository.findByName(routeDataDto.getName());
        return BeanTransFormUtil.transUpdateRouteDo(byName,routeDataDto);
    }

    public RouteDo fromRouteByUploadJson(String routeJson) {
        return BeanTransFormUtil.transRouteDoByUpload(routeJson);
    }
}
