package com.mmc.tmj.service.login.impl;

import com.mmc.tmj.entity.other.LoginTokenInfo;
import com.mmc.tmj.service.login.LoginService;
import com.mmc.tmj.utils.JWTUtil;
import io.jsonwebtoken.Claims;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

/**
 * @Author lcz
 * @Date 2022/5/12 15:48
 * @Version 1.0
 * @description
 */
@Service
public class LoginServiceImpl implements LoginService {

    @Value("${mmcflying.base64Secret}")
    private String base64Secret;

    @Value("${mmcflying.tokenAllowHash}")
    private String tokenAllowHash;
    @Resource
    private StringRedisTemplate redisUserTemplate;

    @Override
    public LoginTokenInfo getLoginInfo(String token, String appid) {
        String appToken = appid+token;
        String identity =(String) redisUserTemplate.opsForHash().get(appToken, "mmc-identity");
        String flyingsessionid =(String) redisUserTemplate.opsForHash().get(appToken, "FLYINGSESSIONID");
        LoginTokenInfo loginTokenInfo = new LoginTokenInfo();
        loginTokenInfo.setMmc_identity(identity);
        loginTokenInfo.setFLYINGSESSIONID(flyingsessionid);
        return loginTokenInfo;
    }

    @Override
    public boolean checkLoginInfo(String token) {
        String jwtToken = token;
        String realToken = jwtToken.replace(JWTUtil.TOKEN_PREFIX, "");
        Claims claims = JWTUtil.parseJWT(realToken, base64Secret);
        if(null == claims){
            return false;
        }
        String userId = claims.get(JWTUtil.X_USER_ID)+"";
        Object oldToken = redisUserTemplate.opsForHash().get(tokenAllowHash, userId);
        if(null != oldToken && jwtToken.equals(oldToken.toString())){
            return true;
        }
        return false;
    }


}
