package com.mmc.tmj.service.file.impl;

import com.mmc.tmj.configuration.MinioPropConfiguration;
import com.mmc.tmj.exception.BaseException;
import com.mmc.tmj.service.file.StoreageService;
import io.minio.MinioClient;
import io.minio.policy.PolicyType;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import lombok.SneakyThrows;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/**
 * @Author lcz
 * @Date 2022/5/14 13:46
 * @Version 1.0
 * @description
 */
@Service
public class MinioStoreageServiceImpl implements StoreageService {
    @Autowired
    private MinioClient minioClient;
    private MinioPropConfiguration minioPropConfiguration;

    @Value("${spring.profiles.active}")
    private String bucketName;

    @SneakyThrows
    public void init(){
        if(!minioClient.bucketExists(bucketName)){
            minioClient.makeBucket(bucketName);
            minioClient.setBucketPolicy(bucketName,"*", PolicyType.READ_WRITE);
        }
    }

    @SneakyThrows
    @Override
    public String store(MultipartFile ia) {
        String fileName =bucketName +"_"+System.currentTimeMillis()+"_"+ia.getName();
        minioClient.putObject(bucketName,fileName,ia.getInputStream(),ia.getContentType());
        return minioPropConfiguration.getEndpoint()+"/"+bucketName+"/"+fileName;
    }

    @SneakyThrows
    @Override
    public String storeElseAndRename(MultipartFile file, Path dir, String newName) {
        //判空
        if(null == file){
            throw new BaseException("Failed to store empty file " + newName, BaseException.FILE_EMPTY);
        }
        if(newName.contains("..")){
            throw new BaseException(
                "Cannot store file with relatvie path outside current directory " + newName,
                BaseException.FILE_STORE_OUTSIDE_CURRENT_DIRECTORY);
        }
        try (InputStream inputStream = file.getInputStream()){
            Files.copy(inputStream,dir.resolve(newName), StandardCopyOption.REPLACE_EXISTING);
        }
        //特殊字符判断
        return newName;
    }

    @Override
    public Path loadFromElse(Path dir, String fileName) {
        return dir.resolve(fileName);
    }
}
