package com.mmc.tmj.mapper;

import com.mmc.tmj.entity.database.TaskDto;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

/**
 * @Author lcz
 * @Date 2022/5/9 9:46
 * @Version 1.0
 * @description
 */

public interface TaskRepository extends JpaRepository<TaskDto,Integer> , QuerydslPredicateExecutor<TaskDto> {



    public TaskDto findByTaskName(String taskName);


    @Query(
        nativeQuery = true,
        value = "update task_dto set task_status =:status ,start_time=now() where id=:id"
    )
    public boolean updateTaskStatus(@Param("id") Integer id,@Param("status") int status);

    public TaskDto findByIdAndTaskStatus(Integer id,int taskStatus);

    @Query("select 1 from TaskDto where deviceId=:id and (taskStatus=1 or taskStatus=2)")
    Integer deviceHaveTask(Integer id);

    @Query(
        nativeQuery = true,
        value = "select count(1) from task_dto where task_status = 3 and id =:taskId"
    )
    Integer checkTaskStatus(@Param("taskId") Integer taskId);

    @Transactional
    @Modifying
    @Query(
        nativeQuery = true,
        value = "insert task_report values (null,?1,?2,0)"
    )
    void saveTaskReportInfo(Integer taskId, String uploadPath);
}
