package com.mmc.tmj.mapper;

import com.mmc.tmj.entity.database.DeviceDo;
import com.mmc.tmj.entity.database.DeviceList;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;

/**
 * @Author lcz
 * @Date 2022/5/17 16:33
 * @Version 1.0
 * @description
 */
public interface DeviceRepository extends JpaRepository<DeviceDo, Integer>,
    QuerydslPredicateExecutor<DeviceDo> {

    /*@Select({"<script>"
        + "SELECT "
        + "d.device_id as device_id, "
        + "d.deviceName, "
        + "d.deviceSerial, "
        + "d.deviceHardId, "
        + "d.hashId as deviceHashId, "
        + "d.STATUS as socketStatus "
        + "FROM "
        + "`mmc_device` AS d "
        + "WHERE "
        + "d.is_del = 0 "
        + "AND d.device_id IN "
        + "(SELECT mdau.device_id "
        + "FROM mmc_device_app_user AS mdau "
        + "WHERE mdau.user_id IN "
        + "(SELECT id "
        + "FROM mmc_user "
        + "WHERE company_id = #{companyId} AND STATUS != 99 )) "
        + "</script>"})*/
    @Query(
        nativeQuery = true,
        value =  "SELECT "
            + "d.device_id as device_id, "
            + "d.deviceName, "
            + "d.deviceSerial, "
            + "d.deviceHardId, "
            + "d.hashId as deviceHashId, "
            + "d.STATUS as socketStatus "
            + "FROM "
            + "`mmc_device` AS d "
            + "WHERE "
            + "d.is_del = 0 "
            + "AND d.device_id IN "
            + "(SELECT mdau.device_id "
            + "FROM mmc_device_app_user AS mdau "
            + "WHERE mdau.user_id IN "
            + "(SELECT id "
            + "FROM mmc_user "
            + "WHERE company_id = :companyId AND STATUS != 99 )) ")
    List<DeviceList> devicesByCompanyId(@Param("companyId") Integer companyId);

    @Query(nativeQuery = true,value = "update  mmc_device set deviceName = :deviceName where  deviceHardId = :deviceHardId ")
    public int updateDeviceNameByDeviceHardId(String deviceHardId , String deviceName);
}
