package com.mmc.tmj.exception;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @Author lcz
 * @Date 2022/5/16 14:42
 * @Version 1.0
 * @description
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
public class BaseException  extends RuntimeException{

    public static final int FILE_STORE_OUTSIDE_CURRENT_DIRECTORY = 11003;
    public static final int FILE_EMPTY = 11002;
    private static final int SERVER_CODE = 500;
    private int code;

    private String msg;


    public BaseException(String msg) {
        super(msg);
        this.msg=msg;
        this.code=SERVER_CODE;
    }


    public BaseException(String msg,Throwable throwable) {
        super(msg,throwable);
        this.msg=msg;
        this.code=SERVER_CODE;
    }


    public BaseException(String msg,int code) {
        super(msg);
        this.msg=msg;
        this.code=code;
    }

    public BaseException(String msg,int code,Throwable throwable) {
        super(msg,throwable);
        this.msg=msg;
        this.code=code;
    }

}
