package com.mmc.tmj.entity.result;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Author lcz
 * @Date 2022/5/17 10:38
 * @Version 1.0
 * @description
 */
@Data
@ApiModel(description = "航线列表")
public class RouteList {
    @ApiModelProperty(value = "航线名称", example = "xxx")
    private String name;

    @ApiModelProperty(value = "默认海拔", example = "10.56987")
    private Double defaultAltitude;

    @ApiModelProperty(value = "默认速度（m/s）", example = "10")
    private Double defaultSpeed;

    @ApiModelProperty(value = "备注", example = "No Comment")
    private String remark;

    @ApiModelProperty(value = "航线ID", example = "1")
    private Integer id;

    @ApiModelProperty(value = "航点数量", example = "10")
    private int numOfPoint;

    @ApiModelProperty(value = "航线长度（单位km）", example = "10")
    private double kmOfRoute;

    @ApiModelProperty(value = "预计时长（单位min）", example = "10")
    private double expectTakeMinute;

    @ApiModelProperty(value = "创建时间", example = "20210803")
    private String createWhen;

}
