package com.mmc.tmj.entity.result;

import com.mmc.tmj.enums.ActionType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @Author lcz
 * @Date 2022/5/16 17:58
 * @Version 1.0
 * @description
 */
@Data
@ApiModel(description = "动作详情")
public class ActionDetail {
    @ApiModelProperty(value = "动作类型", example = "STAY")
    @NotNull
    private ActionType type;
    /** 动作耗时，目前单位是second */
    @ApiModelProperty(value = "动作耗时（s）或拍照数量（张）", example = "10")
    private Integer takeSecond;
}
