package com.mmc.tmj.entity.param;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @Author lcz
 * @Date 2022/5/7 17:56
 * @Version 1.0
 * @description
 */
@Data
public class TaskWebDto {
    /** 任务id */
    @ApiModelProperty(value = "任务id")
    private Integer id;

    /** 任务名称 */
    @ApiModelProperty(value = "任务名称", example = "测试任务1")
    @NotNull(message = "taskName不能为空")
    private String taskName;
    /** 航线 */
    @ApiModelProperty(value = "航线名称", example = "测试航线1")
    @NotNull(message = "routeName不能为空")
    private String routeName;
    /** 责任部门名称 */
    @ApiModelProperty(value = "部门名称", example = "科比特")
    @NotNull(message = "organizationName不能为空")
    private String organizationName;
    /** 无人机id */
    @ApiModelProperty(value = "设备id", example = "67")
    @NotNull(message = "deviceId不能为空")
    private Integer deviceId;
    /** 无人机名称 */
    @ApiModelProperty(value = "设备名称", example = "入云龙11")
    @NotNull(message = "deviceName不能为空")
    private String deviceName;

    @ApiModelProperty(value = "设备硬件ID", example = "入云龙11")
    @NotNull(message = "deviceHardId不能为空")
    private String deviceHardId;
    /** 无人机状态（0:离线1:在线） */
    @ApiModelProperty(value = "设备状态 0:离线 1:在线", example = "1")
    @NotNull(message = "deviceStatus不能为空")
    private Integer deviceStatus;
    /** 任务描述 */
    @ApiModelProperty(value = "任务描述", example = "一个任务")
    private String remark;

}
