package com.mmc.tmj.entity.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @Author lcz
 * @Date 2022/5/21 14:59
 * @Version 1.0
 * @description
 */
@Data
@ApiModel("运行项目web")
public class RunProjectWebDto{
    // 当前登陆账号id
    @NotNull
    private Integer accountId;
    @ApiModelProperty(value = "运行项目名称", required = true, example = "xxx")
    @NotBlank
    private String projectName;
    @ApiModelProperty(value = "运行项目简介", required = true, example = "xxx")
    private String projectDescript;

}
