package com.mmc.tmj.entity.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Data;


/**
 * @Author lcz
 * @Date 2022/5/14 16:40
 * @Version 1.0
 * @description 航线规划web端数据载体
 */
@Data
@ApiModel("航点规划（创建）模型")
public class RouteDataDto {
    @ApiModelProperty(value = "航线名称", required = true, example = "xxx")
    @NotBlank(message = "航线名称不能为空")
    private String name;

    @ApiModelProperty(value = "默认高度", example = "10.0")
    @DecimalMin("1")
    @DecimalMax("150")
    private Double defaultAltitude;

    @ApiModelProperty(value = "默认速度", example = "10.0")
    @DecimalMin("1")
    @DecimalMax("26")
    private Double defaultSpeed;

    @ApiModelProperty(value = "默认偏航角", example = "10.56987")
    private Double defaultYawAngle;

    @ApiModelProperty(value = "默认俯仰角", example = "10.56987")
    private Double defaultPitchAngle;

    @Valid
    @NotNull(message = "points不能为空")
    private List<RoutePointDataDto> points;



}
