package com.mmc.tmj.entity.param;

import com.mmc.tmj.enums.ActionType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @Author lcz
 * @Date 2022/5/16 11:13
 * @Version 1.0
 * @description
 */
@Data
@ApiModel(description = "动作模型")
public class ActionWebDto {
    @ApiModelProperty(value = "动作类型", example = "STAY")
    @NotNull
    private ActionType type;
    /** 动作耗时，目前单位是second */
    @ApiModelProperty(value = "动作耗时（s）或拍照数量（张）", example = "10")
    private Integer takeSecond;

    /*
    * 拍照数量
    * */
    private Integer takePhotoNumber;
}
