package com.mmc.tmj.controller;

import com.mmc.tmj.entity.other.DataObj;
import com.mmc.tmj.entity.other.LoginTokenInfo;
import com.mmc.tmj.entity.param.TaskWebDto;
import com.mmc.tmj.entity.result.BaseResponse;
import com.mmc.tmj.entity.result.DeviceSelectDto;
import com.mmc.tmj.entity.result.PageRespVo;
import com.mmc.tmj.entity.result.PhotographListVo;
import com.mmc.tmj.entity.result.TaskInfoVo;
import com.mmc.tmj.entity.result.TaskListVo;
import com.mmc.tmj.entity.result.TaskSelectVo;
import com.mmc.tmj.service.device.DeviceService;
import com.mmc.tmj.service.file.impl.MinioStoreageServiceImpl;
import com.mmc.tmj.service.login.LoginService;
import com.mmc.tmj.service.photo.PhotographService;
import com.mmc.tmj.service.task.TaskService;
import com.mmc.tmj.utils.BeanTransFormUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.websocket.server.PathParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/**
 * @Author lcz
 * @Date 2022/5/7 14:38
 * @Version 1.0
 * @description
 */
@Api(tags = "任务")
@Slf4j
@Validated
@RequestMapping("/task")
@RestController
public class TaskController {
    @Resource
    private TaskService taskService;

    @Resource
    private LoginService loginService;

    @Resource
    private DeviceService deviceService;

    @Resource
    private MinioStoreageServiceImpl minioStoreageService;

    @Resource
    private PhotographService photographService;


    //创建任务
    @ApiOperation("创建任务")
    @PostMapping("/createTask")
    public BaseResponse createTask(@Valid @RequestBody TaskWebDto taskWebDto){
        if(taskService.createTask(taskWebDto)){
            return BaseResponse.ok("创建成功", 200, "{}");
        };
        return BaseResponse.error("创建失败,任务名称已存在", 400, "{}");
    }

    //分页获取任务列表
    @ApiOperation("获取任务列表")
    @PostMapping("/getTaskList")
    public BaseResponse getTaskList(
        @RequestParam(defaultValue = "") String taskName,
        @RequestParam(defaultValue = "") String status,
        @RequestParam(defaultValue = "1") int num,
        @RequestParam(defaultValue = "10") int size,
        HttpServletRequest request){
        //查询对应的任务列表数据
        PageRespVo<TaskListVo> taskList = taskService.getTaskList(taskName, status, num, size);
        //LoginTokenInfo loginInfo = loginService.getLoginInfo(request.getHeader("token"), "88990");
        /*DataObj exec = deviceService.getDeviceSelect(loginInfo, 1);
        List<Map<String,String>> data =(List<Map<String,String>>) exec.getData();
        List<DeviceSelectDto> deviceSelectDtos = data.stream().map(it -> {
            DeviceSelectDto deviceSelectDto = new DeviceSelectDto();
            deviceSelectDto.setDevice_id(Integer.parseInt(it.get("device_id")));
            deviceSelectDto.setDeviceName(it.get("deviceName"));
            deviceSelectDto.setDeviceHashId(it.get("hashId"));
            deviceSelectDto.setDeviceSerial(it.get("deviceSerial"));
            deviceSelectDto.setDeviceHardId(it.get("deviceHardId"));
            deviceSelectDto.setSocketStatus(Integer.parseInt(it.get("status")));
            return deviceSelectDto;
        }).collect(Collectors.toList());
        for(TaskListVo taskListVo:taskList.getData()){
            if(null != taskListVo.getDeviceHardId() && taskListVo.getDeviceHardId().startsWith("mock-")){
                taskListVo.setDeviceStatus(1);
                continue;
            }
            for (DeviceSelectDto deviceSelectDto:deviceSelectDtos){
                if(deviceSelectDto.getDevice_id().equals(taskListVo.getDeviceId())){
                    taskListVo.setDeviceStatus(deviceSelectDto.getSocketStatus());
                    break;
                }else {
                    taskListVo.setDeviceStatus(0);
                }

            }
        }*/
        return BaseResponse.ok("查询成功", 200, taskList);
    }

    //选择任务列表(可带名称查询)
    @ApiOperation("选择任务列表(可带名称查询)")
    @GetMapping("/getTaskSelect")
    public BaseResponse<List<TaskSelectVo>> getSelectList(@RequestParam(required = false) String name){
        return BaseResponse.ok(taskService.getTaskSelect(name));
    }

    //更新任务
    @ApiOperation("更新任务")
    @PutMapping("/updateTask")
    public BaseResponse updateTask(@Valid @RequestBody TaskWebDto taskWebDto) {
        if(taskService.updateTask(taskWebDto)){
            return BaseResponse.ok("更新成功", 200, "{}");
        };
        return BaseResponse.error("更新失败,任务名称已存在", 400, "{}");
    }

    //任务详情
    @ApiOperation("任务详情")
    @GetMapping("/getTaskInfoById")
    public BaseResponse<TaskInfoVo> getTaskInfoById(@RequestParam Integer id){
        TaskInfoVo taskInfoVo=taskService.getTaskInfoById(id);
        return BaseResponse.ok(taskInfoVo);
    }

    //开始任务
    @ApiOperation("开始任务")
    @GetMapping("/startTask")
    public BaseResponse startTask(@RequestParam Integer id){
        if(taskService.updateTaskStatus(id,1,2)){
            return BaseResponse.ok("开始任务成功", 200, "{}");
        };
        return BaseResponse.error("开始任务失败", 400, "{}");
    }
    //完成任务
    @ApiOperation("完成任务")
    @GetMapping("/endTask")
    public BaseResponse endTask(@RequestParam Integer id){
        if(taskService.updateTaskStatus(id,2,3)){
            return BaseResponse.ok("完成任务成功", 200, "{}");
        };
        return BaseResponse.error("完成任务失败", 400, "{}");
    }
    //保存图片
    @ApiOperation("保存图片")
    @PostMapping(
        value = "/photograph",
        consumes = {MediaType.MULTIPART_FORM_DATA_VALUE})
    public BaseResponse photograph(@RequestParam(
        value = "task_id",required = false) Integer taskId,
        @RequestParam(value = "images") MultipartFile[] images,
        @RequestParam(value = "deviceHardId",defaultValue = "")String deviceHardId){
        Arrays.stream(images).forEach(ia->{
            String fileParm=minioStoreageService.store(ia);
            photographService.savePhotograph(BeanTransFormUtil.transPhotographDo(taskId,deviceHardId,fileParm));
        });
        return BaseResponse.ok("上传成功");
    }

    //查询图片地址
    @ApiOperation("查询图片地址")
    @GetMapping("/getPhotograph")
    public BaseResponse<List<PhotographListVo>> getPhotograph(Integer taskId){
        return BaseResponse.ok("查询成功",200,photographService.getPhotographByTaskId(taskId));
    }

    //删除任务
    @ApiOperation("删除任务")
    @DeleteMapping("/deleteTask/{id}")
    public BaseResponse deleteTask(@PathVariable("id") Integer id){
        if(taskService.deleteTask(id)){
            return BaseResponse.ok("删除任务成功", 200, "{}");
        };
        return BaseResponse.error("删除任务失败", 400, "{}");
    }

}
