package com.mmc.tmj.controller;

import com.mmc.tmj.entity.response.BaseNumListVo;
import com.mmc.tmj.entity.response.ServicePointBaseInfo;
import com.mmc.tmj.entity.response.ServicePointListMapVo;
import com.mmc.tmj.entity.response.ServicePointListSimpleVo;
import com.mmc.tmj.entity.response.TrainPointListMapVo;
import com.mmc.tmj.entity.result.BaseResponse;
import com.mmc.tmj.utils.BeanTransFormUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author lcz
 * @Date 2022/5/21 16:57
 * @Version 1.0
 * @description
 */
@Api(tags = "服务网点")
@Validated
@Slf4j
@RequestMapping("/servicePoint")
@RestController
public class ServicePointController {
    @Autowired
    private Map<String, List<Map<String,Object>>> sumalationData;
    //@GetMapping("/getServicePointNum")
    public BaseResponse<List<BaseNumListVo>> getServicePointNum(@Valid @NotNull @RequestParam Integer accountId){

        return BaseResponse.ok(null);
    }

    @GetMapping("/getServicePointListMap")
    @ApiOperation("获取服务网点数据列表")
    public BaseResponse<List<ServicePointListMapVo>> getServicePointListMap(@Valid @NotNull @RequestParam Integer accountId){
        List<Map<String, Object>> flyer = sumalationData.get("service");
        final int[] i = {0};
        List<ServicePointListMapVo> mmc1 = flyer.stream().map((map) -> {
            i[0] = i[0] +1;
            return BeanTransFormUtil.transServicePointListMapVoByMap(map, ""+i[0]);
        }).collect(Collectors.toList());
        return BaseResponse.ok(mmc1);
    }

    //@GetMapping("/getServicePointListSimple")
    public BaseResponse<List<ServicePointListSimpleVo>> getServicePointListSimple(@Valid @NotNull @RequestParam Integer accountId){

        return BaseResponse.ok(null);
    }

    //@GetMapping("/getServicePointInfo")
    public BaseResponse<ServicePointBaseInfo> getServicePointInfo(@Valid @NotNull @RequestParam Integer accountId,@Valid @NotNull @RequestParam Integer id){

        return BaseResponse.ok(null);
    }
}
