package com.mmc.tmj.controller;

import com.mmc.tmj.entity.other.RunProjectDto;
import com.mmc.tmj.entity.other.RunProjectListDto;
import com.mmc.tmj.entity.param.RunProjectWebDto;
import com.mmc.tmj.entity.result.BaseResponse;
import com.mmc.tmj.service.runProject.RunProjectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author lcz
 * @Date 2022/5/21 14:14
 * @Version 1.0
 * @description
 */
@Api(tags = "运行项目")
@Validated
@Slf4j
@RequestMapping("/runProject")
@RestController
public class RunPorjectController {
    @Autowired
    private RunProjectService runProjectService;

    //新增项目
    @PostMapping("/createRunProject")
    @ApiOperation("创建运行项目")
    public BaseResponse createRunProject(@Valid @RequestBody RunProjectWebDto runProjectWebDto){
        if(runProjectService.createRunProject(runProjectWebDto)){
            return BaseResponse.ok();
        }
        return BaseResponse.error("重名");
    }

    //查询项目列表
    @GetMapping("/getRunProjectListSimple")
    @ApiOperation("获取培训运行项目列表")
    public BaseResponse<List<RunProjectListDto>> getRunProjectListSimple(@Valid @NotNull @RequestParam Integer accountId,@RequestParam(defaultValue = "") String projectName){
        return BaseResponse.ok(runProjectService.getRunProjectListSimple(accountId,projectName));
    }
    //查看单个项目详情

    @GetMapping("/getRunProjectInfo")
    @ApiOperation("获取运行项目详情")
    public BaseResponse<RunProjectDto> getRunProjectInfo(@Valid @NotNull @RequestParam Integer accountId,@Valid @NotNull @RequestParam Integer id){
        return BaseResponse.ok(runProjectService.getRunProjectInfo(accountId,id));
    }
    //删除项目
    @DeleteMapping("/delete")
    @ApiOperation("删除运行项目")
    public BaseResponse delete(@Valid @NotNull @RequestParam Integer accountId,@Valid @NotNull @RequestParam Integer id){
        if(runProjectService.delete(accountId,id)){
            return BaseResponse.ok();
        }
        return BaseResponse.error("已被删除");
    }
}
