package com.mmc.tmj.controller;

import com.mmc.tmj.entity.response.BaseNumListVo;
import com.mmc.tmj.entity.response.FlyListMapVo;
import com.mmc.tmj.entity.response.FlyListSimpleVo;
import com.mmc.tmj.entity.result.BaseResponse;
import com.mmc.tmj.utils.BeanTransFormUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author lcz
 * @Date 2022/5/21 16:55
 * @Version 1.0
 * @description
 */
@Api(tags = "无人机")
@Validated
@Slf4j
@RequestMapping("/fly")
@RestController
public class FlyController {
    @Autowired
    private Map<String, List<Map<String,Object>>> sumalationData;

    //@GetMapping("/getflyNum")
    public BaseResponse<List<BaseNumListVo>> getflyNum(@Valid @NotNull @RequestParam Integer accountId){

        return BaseResponse.ok(null);
    }

    @GetMapping("/getflyListMap")
    @ApiOperation("获取无人机列表数据")
    public BaseResponse<List<FlyListMapVo>> getflyListMap(@Valid @NotNull @RequestParam Integer accountId){
        List<Map<String, Object>> flyer = sumalationData.get("uav");
        final int[] i = {0};
        List<FlyListMapVo> mmc1 = flyer.stream().map((map) -> {
            i[0] = i[0] +1;
            return BeanTransFormUtil.transFlyListMapVoByMap(map, ""+i[0], "MMC无人机"+i[0]);
        }).collect(Collectors.toList());
        return BaseResponse.ok(mmc1);
    }

    //@GetMapping("/getflyListSimple")
    public BaseResponse<List<FlyListSimpleVo>> getflyListSimple(@Valid @NotNull @RequestParam Integer accountId){

        return BaseResponse.ok(null);
    }

    //@GetMapping("/getflyInfo")
    public BaseResponse<FlyListSimpleVo> getflyInfo(@Valid @NotNull @RequestParam Integer accountId,@Valid @NotNull @RequestParam Integer id){

        return BaseResponse.ok(null);
    }

}
