package com.mmc.tmj.controller;

import com.mmc.tmj.entity.response.BaseNumListVo;
import com.mmc.tmj.entity.response.ExhibitionPointBaseInfo;
import com.mmc.tmj.entity.response.ExhibitionPointListMapVo;
import com.mmc.tmj.entity.response.ExhibitionPointListSimpleVo;
import com.mmc.tmj.entity.result.BaseResponse;
import com.mmc.tmj.utils.BeanTransFormUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author lcz
 * @Date 2022/5/21 16:57
 * @Version 1.0
 * @description
 */
@Api(tags = "展示网点")
@Validated
@Slf4j
@RequestMapping("/exhibitionPoint")
@RestController
public class ExhibitionPointController {
    @Autowired
    private Map<String, List<Map<String,Object>>> sumalationData;
    //@GetMapping("/getExhibitionPointNum")
    public BaseResponse<List<BaseNumListVo>> getExhibitionPointNum(@Valid @NotNull @RequestParam Integer accountId){

        return BaseResponse.ok(null);
    }

    @GetMapping("/getExhibitionPointListMap")
    @ApiOperation("获取展示项目列表")
    public BaseResponse<List<ExhibitionPointListMapVo>> getExhibitionPointListMap(@Valid @NotNull @RequestParam Integer accountId){
        List<Map<String, Object>> flyer = sumalationData.get("show");
        final int[] i = {0};
        List<ExhibitionPointListMapVo> mmc1 = flyer.stream().map((map) -> {
            i[0] = i[0] +1;
            return BeanTransFormUtil.transExhibitionPointListMapVoByMap(map, ""+i[0]);
        }).collect(Collectors.toList());
        return BaseResponse.ok(mmc1);
    }

    //@GetMapping("/getExhibitionPointListSimple")
    public BaseResponse<List<ExhibitionPointListSimpleVo>> getExhibitionPointListSimple(@Valid @NotNull @RequestParam Integer accountId){

        return BaseResponse.ok(null);
    }

    //@GetMapping("/getExhibitionPointInfo")
    public BaseResponse<ExhibitionPointBaseInfo> getExhibitionPointInfo(@Valid @NotNull @RequestParam Integer accountId,@Valid @NotNull @RequestParam Integer id){

        return BaseResponse.ok(null);
    }
}
