package com.mmc.tmj.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

/**
 * @Author lcz
 * @Date 2022/5/18 16:22
 * @Version 1.0
 * @description
 */
@Configuration
@EnableSwagger2WebMvc
public class Knife4jConfig {
    @Bean(value = "defaultApi2")
    public Docket defaultApi2() {
        return new Docket(DocumentationType.SWAGGER_2)
            .apiInfo(
                new ApiInfoBuilder()
                    .title("TMJ基础平台")
                    .description("TMJ基础平台文档")
                    .termsOfServiceUrl("http://www.mmc.cn/tmj")
                    .version("0.0.1")
                    .build())
            // 分组名称
            .groupName("开发版本")
            .select()
            // 这里指定Controller扫描包路径
            .apis(RequestHandlerSelectors.basePackage("com.mmc"))
            .paths(PathSelectors.any())
            .build();
    }

}
