package com.mmc.csf.release.util;

import com.mmc.csf.infomation.vo.PersonSendOrderVO;
import com.mmc.csf.release.dao.RequirementsDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@Component
public class ScheduledTaskUtil {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private TaskScheduler taskScheduler;

    @Autowired
    private RequirementsDao requirementsDao;

    private final Map<Integer, ScheduledFuture<?>> scheduledTasks = new ConcurrentHashMap<>();

    public void create(PersonSendOrderVO personSendOrderVO){
        long delay = 10000; // 延迟5s开始执行
        MyTask task = new MyTask(requirementsDao);
        task.setPersonSendOrderVO(personSendOrderVO);
        redisTemplate.setValueSerializer(new GenericJackson2JsonRedisSerializer());
        redisTemplate.opsForValue().set("task"+personSendOrderVO.getRequirementsInfoId(), task, delay, TimeUnit.MILLISECONDS);
        // 使用TaskScheduler执行定时任务
        System.out.println("定时任务已开启");
        ScheduledFuture<?> scheduledFuture = taskScheduler.schedule(task, Instant.now().plusMillis(delay));
        scheduledTasks.put(personSendOrderVO.getRequirementsInfoId(), scheduledFuture);
    }

    public void destroy(Integer requireId){
        redisTemplate.setValueSerializer(new GenericJackson2JsonRedisSerializer());
        MyTask task = (MyTask) redisTemplate.opsForValue().get("task"+requireId);
        ScheduledFuture<?> scheduledFuture = scheduledTasks.get(requireId);
        if (task != null && scheduledFuture != null) {
            scheduledFuture.cancel(false);
            redisTemplate.delete("task"+requireId);
            scheduledTasks.remove(requireId);
            System.out.println("定时任务已取消");
        }
    }
}
