package com.mmc.csf.release.service.impl;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import com.mmc.csf.common.util.redis.RedisConstant;
import com.mmc.csf.infomation.dto.UserBaseInfoDTO;
import com.mmc.csf.release.feign.PmsAppApi;
import com.mmc.csf.release.util.SmsUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.UserAccountSimpleDTO;
import com.mmc.csf.release.auth.qo.UserAccountQO;
import com.mmc.csf.release.constant.TokenConstant;
import com.mmc.csf.release.dao.CommentDAO;
import com.mmc.csf.release.dao.DynamicDao;
import com.mmc.csf.release.dao.LikeDAO;
import com.mmc.csf.release.dao.gambit.GambitDao;
import com.mmc.csf.release.entity.forum.*;
import com.mmc.csf.release.entity.gambit.ForumAttentionDO;
import com.mmc.csf.release.entity.gambit.ForumGambitDO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.forum.vo.*;
import com.mmc.csf.release.gambit.dto.ForumGambitDTO;
import com.mmc.csf.release.gambit.dto.PostingLeaderboardDTO;
import com.mmc.csf.release.gambit.qo.ForumGambitQO;
import com.mmc.csf.release.gambit.qo.PostingLeaderboardQO;
import com.mmc.csf.release.service.DynamicService;
import com.mmc.csf.release.service.WxApiService;
import com.mmc.csf.user.vo.ChangeUserPointVO;
import com.mmc.csf.user.vo.UserAccountVO;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.web.client.RestTemplate;

/**
 * @Author LW
 * @date 2023/5/15 10:29 概要：动态信息实现层
 */
@Service
@Slf4j
public class DynamicServiceImpl implements DynamicService {

    @Resource
    private DynamicDao dynamicDao;
    @Resource
    private LikeDAO likeDAO;
    @Resource
    private CommentDAO commentDAO;
    @Autowired
    private UserAppApi userAppApi;
    @Resource
    private WxApiService wxApiService;

    @Autowired
    private GambitDao gambitDao;


    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private PmsAppApi pmsAppApi;

    @Value("${iuav.userapp.url}")
    private String userApp;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResultBody insertDynamic(DynamicVO dynamicVO, Integer userAccountId, HttpServletRequest request) {
        log.info("用户：{}发布动态:{}",userAccountId, dynamicVO);
        // 获取用户openid
        UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(userAccountId, request.getHeader(TokenConstant.TOKEN));
        if(userAccountSimpleDTO.getPhoneNum()==null || "".equals(userAccountSimpleDTO.getPhoneNum())){
            return ResultBody.error("请先绑定手机号");
        }
        // 插入动态基本信息
        ForumDynamicDO forumDynamicDO = new ForumDynamicDO(dynamicVO);
        forumDynamicDO.setRootPath(null);
        forumDynamicDO.setUserAccountId(userAccountId);
        //插入用户
        int count = dynamicDao.selectForumCount(userAccountId);
        if (count==0){
            dynamicDao.insertForumCount(userAccountId);
        }
        // 插入动态资源
        if (CollectionUtils.isNotEmpty(dynamicVO.getMediaVO())) {
            forumDynamicDO.setCheckStatus(0);
            dynamicDao.insertDynamic(forumDynamicDO);
            for (MediaVO mediaVO : dynamicVO.getMediaVO()) {
                dynamicDao.insertResource(forumDynamicDO.getId(), mediaVO.getType(), mediaVO.getUrl());
            }
            //话题通过
            List<String> gambitName = dynamicVO.getGambitName();
            ForumGambitDO forumGambitDO = new ForumGambitDO(forumDynamicDO);
            if (gambitName!=null){
                if (gambitName.size()!=0){
                    for (String s : gambitName) {
                        boolean b = s.startsWith("#");
                        if (b==true){
                            forumGambitDO.setGambitName(s);
                            ForumGambitDO forumGambitDO1 = gambitDao.selectGambitMessage(forumGambitDO.getGambitName());
                            if (forumGambitDO1==null){
                                forumGambitDO.setCheckStatus(0);
                                dynamicDao.insertforumGambit(forumGambitDO);
                            }
                            if (forumGambitDO1!=null){
                                forumGambitDO.setId(forumGambitDO1.getId());
                            }
                            DynamicGambitDO dynamicGambitDO = new DynamicGambitDO(forumDynamicDO,forumGambitDO);
                            dynamicGambitDO.setCheckStatus(0);
                            dynamicDao.insertDynamicGambit(dynamicGambitDO);
                        }
                    }
                }
            }
            return ResultBody.success("您的信息通过审核后，即可向其他人展示");
        } else {
            ResultBody resultBody = wxApiService.msgSecCheck(userAccountSimpleDTO.getOpenid(), dynamicVO.getDescription());
            if (resultBody.getCode().equals("200")) {
                //审核通过
                forumDynamicDO.setCheckStatus(1);
                dynamicDao.insertDynamic(forumDynamicDO);
                //话题通过
                List<String> gambitName = dynamicVO.getGambitName();
                ForumGambitDO forumGambitDO = new ForumGambitDO(forumDynamicDO);
                if (gambitName!=null){
                    if (gambitName.size()!=0 ){
                        for (String s : gambitName) {
                            boolean b = s.startsWith("#");
                            if (b==true){
                                forumGambitDO.setGambitName(s);
                                ForumGambitDO forumGambitDO1 = gambitDao.selectGambitMessage(forumGambitDO.getGambitName());
                                if (forumGambitDO1==null){
                                    forumGambitDO.setCheckStatus(1);
                                    dynamicDao.insertforumGambit(forumGambitDO);
                                    Integer id = forumDynamicDO.getId();
                                    dynamicDao.updateDynamic(id);
                                    dynamicDao.updateDiscussionCounts(id);
                                }
                                if (forumGambitDO1!=null){
                                    forumGambitDO.setId(forumGambitDO1.getId());
                                }
                                DynamicGambitDO dynamicGambitDO = new DynamicGambitDO(forumDynamicDO,forumGambitDO);
                                dynamicGambitDO.setCheckStatus(1);
                                dynamicDao.insertDynamicGambit(dynamicGambitDO);
                                Integer id = forumGambitDO.getId();
                                dynamicDao.updateDynamic(id);
                                dynamicDao.updateDiscussionCounts(id);
                            }
                        }
                    }
                }
                // 论坛通过发积分，暂时先发5积分
                ChangeUserPointVO changePoint = new ChangeUserPointVO();
                changePoint.setUserAccountId(userAccountId);
                changePoint.setChangeType(3);
                changePoint.setChangePoint(5);
                userAppApi.changeUserPoint(changePoint, request.getHeader(TokenConstant.TOKEN));
            } else {
                forumDynamicDO.setCheckStatus(2);
                dynamicDao.insertDynamic(forumDynamicDO);
            }
            return resultBody;
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResultBody updateDynamic(UpdateDynamicDO updateDynamicDO) {
        List<MediaVO> mediaVOList = updateDynamicDO.getMediaVO();
        dynamicDao.deleteResource(updateDynamicDO.getId());
        if(mediaVOList != null){

            for (MediaVO mediaVO : mediaVOList) {
                dynamicDao.insertResource(updateDynamicDO.getId(), mediaVO.getType(), mediaVO.getUrl());
            }
        }
        if(updateDynamicDO.getDescription() != null){
            dynamicDao.updateDynamicDescription(updateDynamicDO.getId(), updateDynamicDO.getDescription());
        }
        return ResultBody.success("修改成功");
    }

    @Override
    public ResultBody likeDynamic(HttpServletRequest request,Integer userId, Integer dynamicId) {
        // 获取动态信息
        ForumDynamicDO forumDynamicDO = dynamicDao.getDynamicInfo(dynamicId);
        if (!likeDAO.isLiked(userId, dynamicId)) {
            likeDAO.insertLike(userId, dynamicId);
            dynamicDao.updateDynamicLikeCount(dynamicId, forumDynamicDO.getVersion());
            dynamicDao.forumCount(forumDynamicDO.getUserAccountId());
            String s = stringRedisTemplate.opsForValue().get(RedisConstant.USER_LIKE_DYNAMIC + dynamicId + ":" + userId);
            if (s == null) {
                stringRedisTemplate.opsForValue().set(RedisConstant.USER_LIKE_DYNAMIC + dynamicId + ":" + userId, "1");
                userAppApi.changeUserPoints(request.getHeader(TokenConstant.TOKEN),request, 4);
            }

        } else {
            likeDAO.deleteLike(userId, dynamicId);
            dynamicDao.updateSubDynamicLikeCount(dynamicId, forumDynamicDO.getVersion());
            dynamicDao.forumCountNO(forumDynamicDO.getUserAccountId());
        }
        return ResultBody.success();
    }


    private boolean isVoted(Integer gambitId, Integer userAccountId) {
        if (gambitId == 1001 || gambitId == 1002 || gambitId == 1003) {
            boolean keyExists = stringRedisTemplate.hasKey(RedisConstant.VOTE + gambitId + userAccountId);
            if(keyExists){
                String  voteStr = stringRedisTemplate.opsForValue().get(RedisConstant.VOTE + gambitId +userAccountId);
                int voteCount = Integer.parseInt(voteStr);
                if(voteCount >= 5){
                    return false;
                }
                stringRedisTemplate.opsForValue().set(RedisConstant.VOTE + gambitId + userAccountId, String.valueOf(voteCount+1));
                return true;
            }
            stringRedisTemplate.opsForValue().set(RedisConstant.VOTE + gambitId + userAccountId, "1");
            return true;
        }
        return true;
    }

    @Override
    public ResultBody getRemainingVotes(Integer gambitId, Integer userAccountId) {
        boolean keyExists = stringRedisTemplate.hasKey(RedisConstant.VOTE + gambitId + userAccountId);
        if(keyExists){
            String  voteStr = stringRedisTemplate.opsForValue().get(RedisConstant.VOTE + gambitId +userAccountId);
            int voteCount = Integer.parseInt(voteStr);
            //voteCount是已经投票的次数，一个最多投五次
            return ResultBody.success(5-voteCount);
        }
        return ResultBody.success(5);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResultBody commentDynamic(CommentVO commentVO, Integer userAccountId, HttpServletRequest request) {
        UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(userAccountId, request.getHeader(TokenConstant.TOKEN));
        ForumDynamicDO forumDynamicDO = dynamicDao.getDynamicInfo(commentVO.getDynamicId());
        if (forumDynamicDO == null) {
            return ResultBody.error("动态不存在或已删除");
        }
        // todo openid 需要获取
        ResultBody resultBody = wxApiService.msgSecCheck(userAccountSimpleDTO.getOpenid(), commentVO.getContent());
        if (resultBody.getCode().equals("200")) {
            // 新增评论
            commentVO.setUserAccountId(userAccountId);
            ForumFirstLevelReviewDO forumFirstLevelReviewDO = new ForumFirstLevelReviewDO(commentVO);
            // dynamicDao.insertDynamic(comment);
            dynamicDao.insertforumFirstLevelReview(forumFirstLevelReviewDO);
            // 修改评论数量
            dynamicDao.updateDynamicCommentCount(commentVO.getDynamicId(), forumDynamicDO.getVersion());
            UserBaseInfoDTO user1 = userAppApi.feignGetUserBaseInfo(forumDynamicDO.getUserAccountId());
            if(forumFirstLevelReviewDO.getReviewId() != 0){
                ForumFirstLevelReviewDO forumFirstLevelReviewDO1 = dynamicDao.selectForumFirstLevelReview(forumFirstLevelReviewDO.getReviewId());
                UserBaseInfoDTO user2 = userAppApi.feignGetUserBaseInfo(forumFirstLevelReviewDO1.getUserAccountId());
                SmsUtil.sendCommentDynamic(user2.getPhoneNum());
            }
            SmsUtil.sendCommentDynamic(user1.getPhoneNum());
            return ResultBody.success();
        } else {
            return resultBody;
        }
    }

    @Override
    public ResultBody deleteComment(Integer id) {
        commentDAO.deleteComment(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody dynamicDetails(Integer dynamicId, Integer userId, HttpServletRequest request) {

        boolean isAdmin = userId == 1;

        // 判断此动态是否还存在
        ForumDynamicDO dynamicInfo = dynamicDao.getDynamicInfoById(dynamicId);
        if (dynamicInfo == null) {
            return ResultBody.error("动态不存在！");
        }
        DynamicVO dynamicVO = dynamicInfo.buildDynamicVO();
        // 设置是否点赞
        boolean liked = likeDAO.isLiked(userId, dynamicId);

        UserAccountSimpleDTO userAccountSimpleDTO =
                userAppApi.feignGetUserSimpleInfo(
                        dynamicInfo.getUserAccountId(), request.getHeader(TokenConstant.TOKEN));
        UserBaseInfoVO userBaseInfoVO = new UserBaseInfoVO();

        userBaseInfoVO.setNickName(userAccountSimpleDTO.getNickName());
        userBaseInfoVO.setUserImg(userAccountSimpleDTO.getUserImg());
        userBaseInfoVO.setIsPilot(userAccountSimpleDTO.getIsPilot());
        dynamicVO.setUserBaseInfo(userBaseInfoVO);
        dynamicVO.setLikes(liked);
        ForumReviewVO forumReviewVO = gambitDao.selectForumReviewMessage(dynamicId);
        dynamicVO.setForumReviewVO(forumReviewVO);
        if (forumReviewVO!=null){
           Integer userAccountId = forumReviewVO.getUserAccountId();
            UserAccountVO info = info(userAccountId);
            forumReviewVO.setUserAccountVO(info);
         }
            ArrayList<String> list = new ArrayList<>();
            List<ForumGambitDO> gambitDOS = dynamicDao.selectGambit(dynamicId);
        List<ForumGambitDTO> collect = gambitDOS.stream().map(ForumGambitDO::buildForumGambitDTO).collect(Collectors.toList());
        dynamicVO.setForumGambitDTOList(collect);
        for (ForumGambitDO gambitDO : gambitDOS) {
             list.add(gambitDO.getGambitName());
            }
        dynamicVO.setGambitName(list);


        // 获取媒体资源
        List<ForumResourceDO> forumResourceList = dynamicDao.listDynamicResources(dynamicId);
        if (CollectionUtils.isNotEmpty(forumResourceList)) {
            List<MediaVO> MediaVOList =
                    forumResourceList.stream().map(ForumResourceDO::buildMedia).collect(Collectors.toList());
            dynamicVO.setMediaVO(MediaVOList);
        }
        // 动态评论列表
        if(!isAdmin) {
            List<DynamicVO> listDynamic = getCommentInfo(dynamicId, request);
            dynamicVO.setCommentAndReplyVO(listDynamic);
        }

        Integer goodsId = dynamicVO.getGoodsId();
        MallGoodsVO result = pmsAppApi.mallGoodsDetails(goodsId).getResult();
        dynamicVO.setMallGoodsVO(result);
        return ResultBody.success(dynamicVO);
    }

    private List<DynamicVO> getCommentInfo(Integer dynamicId, HttpServletRequest request) {
        // 获取下面所有的一级评论

        List<ForumDynamicDO> forumDynamic = dynamicDao.getDynamicComment(dynamicId.toString());
        if (forumDynamic == null) {
            return new ArrayList<>();
        }
        List<Integer> userAccountIds =
                forumDynamic.stream().map(ForumDynamicDO::getUserAccountId).collect(Collectors.toList());
        UserAccountQO bUserAccountQO = new UserAccountQO();
        bUserAccountQO.setUserIds(userAccountIds);
        bUserAccountQO.setPageNo(1);
        bUserAccountQO.setPageSize(999);


        // 获取用户的信息

        List<UserAccountSimpleDTO> userAccountSimpleDTOS =
                userAppApi.feignListAppUserAccount(bUserAccountQO, request.getHeader(TokenConstant.TOKEN));




        List<DynamicVO> listDynamic =
                forumDynamic.stream().map(ForumDynamicDO::buildDynamicVO).collect(Collectors.toList());
        for (DynamicVO dynamicVO : listDynamic) {
            for (UserAccountSimpleDTO userAccountSimpleDTO : userAccountSimpleDTOS) {
                if (dynamicVO.getUserAccountId().equals(userAccountSimpleDTO.getId())) {
                    UserBaseInfoVO userBaseInfoVO = new UserBaseInfoVO();
                    userBaseInfoVO.setNickName(userAccountSimpleDTO.getNickName());
                    userBaseInfoVO.setUserImg(userAccountSimpleDTO.getUserImg());
                    userBaseInfoVO.setUserName(userAccountSimpleDTO.getUserName());
                    userBaseInfoVO.setPhone(userAccountSimpleDTO.getPhoneNum());
                    userBaseInfoVO.setUid(userAccountSimpleDTO.getUid());
                    dynamicVO.setUserBaseInfo(userBaseInfoVO);
                    break;
                }
            }
        }
        return listDynamic;
    }

    @Override
    public PageResult dynamicList(
            Integer pageNo, Integer pageSize, Integer userId, Integer gambitId,Integer dynId,Integer userAccountIds,
            String description,List<String> gambitName,Integer needSort) {
        Integer tokenUserId =userId;
        Integer inUserId =userAccountIds;
        int count = dynamicDao.countDynamicList(dynId,userAccountIds,description);
        if (count == 0) {
            return PageResult.buildPage(pageNo, pageSize, 0);
        }
        int itemIndex = (pageNo - 1) * pageSize;
        List<ForumDynamicDO> forumDynamicList = dynamicDao.dynamicList(itemIndex, pageSize,dynId,userAccountIds,description,needSort);

       if (gambitName!=null){
           for (String s : gambitName) {
               Integer integer = dynamicDao.gambitName(s);
               forumDynamicList = dynamicDao.dynamicListGambit(itemIndex, pageSize,dynId,userAccountIds,integer,needSort);
           }
       }
       // List<Integer> integers = dynamicDao.gambitName(gambitName);
        if (gambitId!=null){
         forumDynamicList = dynamicDao.dynamicListGambit(itemIndex, pageSize,dynId,userAccountIds,gambitId,needSort);
        }
       for (ForumDynamicDO forumDynamicDO : forumDynamicList) {
            Integer dynamicId = forumDynamicDO.getDynamicId();
           ForumReviewVO forumReviewVO = gambitDao.selectForumReviewMessage(dynamicId);
           if (forumReviewVO!=null){
               Integer i = gambitDao.selectStatus(forumReviewVO.getId(), userId);
               if (i==null){
                   forumReviewVO.setStatus(null);
               }else if (i==1){
                   forumReviewVO.setStatus(true);
               }
           }
           forumDynamicDO.setForumReviewVO(forumReviewVO);
            if (forumReviewVO!=null){
                Integer userAccountId = forumReviewVO.getUserAccountId();
                UserAccountVO info = info(userAccountId);
                forumReviewVO.setUserAccountVO(info);
            }
       }
        for (ForumDynamicDO forumDynamicDO : forumDynamicList) {
            Integer id = forumDynamicDO.getDynamicId();
            ArrayList<String> list = new ArrayList<>();
           // List<ForumGambitDO> gambitDOS = dynamicDao.selectGambit(id);
            List<ForumGambitDTO> gambitDOS=   dynamicDao.selectGambitDTO(id);
            ArrayList<ForumGambitDTO> list1 = new ArrayList<>();
            for (ForumGambitDTO gambitDO : gambitDOS) {
                if (gambitId!=null){
                    if (gambitDO.getId().equals(gambitId)){
                        list.add(gambitDO.getGambitName());
                        list1.add(gambitDO);
                    }
                }else{
                    list.add(gambitDO.getGambitName());
                    list1.add(gambitDO);
                }
            }
            forumDynamicDO.setGambitName(list);
            forumDynamicDO.setGambitDTOList(list1);
        }

        // 动态id集合
        List<Integer> ids =
                forumDynamicList.stream().map(ForumDynamicDO::getId).collect(Collectors.toList());
        // 根据id集合查询评论
        List<ForumDynamicDO> commentList = dynamicDao.firstTwoItemsComment(ids);
        Map<String, List<ForumDynamicDO>> commentMap = commentList.stream().filter(map->map.getRootPath()!=null).collect(Collectors.groupingBy(ForumDynamicDO::getRootPath));
        // 根据id集合查询图片

        if (ids.size()==0){
            return  PageResult.buildPage(pageNo, pageSize, 0, null);
        }
        List<ForumResourceDO> forumImageList = dynamicDao.listDynamicPicture(ids);
        Map<Integer, List<ForumResourceDO>> ImageMap =
                forumImageList.stream().collect(Collectors.groupingBy(ForumResourceDO::getDynamicId));
        // 获取用户信息
        Set<Integer> userIds =
                forumDynamicList.stream().map(ForumDynamicDO::getUserAccountId).collect(Collectors.toSet());
        List<Integer> userIdList = new ArrayList<>(userIds);
        UserAccountQO bUserAccountQO = new UserAccountQO();
        bUserAccountQO.setUserIds(userIdList);
        List<UserAccountSimpleDTO> userAccountSimpleDTOS =
                userAppApi.feignListAppUserAccount1(bUserAccountQO);
        Map<Integer, UserAccountSimpleDTO> userAccountInfoMap =
                userAccountSimpleDTOS.stream()
                        .collect(Collectors.toMap(UserAccountSimpleDTO::getId, Function.identity()));
        // 获取liked信息
        List<ForumDynamicDO> forumDynamicDOS = likeDAO.selectLiked(userId, ids);
        List<DynamicVO> dynamicVOList =
                forumDynamicList.stream()
                        .map(
                                d -> {
                                    DynamicVO dynamicVO = d.buildDynamicVO();
                                    if (ImageMap != null) {
                                        List<ForumResourceDO> forumResourceDOList = ImageMap.get(d.getId());
                                        if (CollectionUtils.isNotEmpty(forumResourceDOList)) {
                                            dynamicVO.setMediaVO(
                                                    forumResourceDOList.stream()
                                                            .map(ForumResourceDO::buildMedia)
                                                            .collect(Collectors.toList()));
                                        }
                                    }
                                    if (commentMap != null) {
                                        List<ForumDynamicDO> comment = commentMap.get(d.getId().toString());
                                        if (CollectionUtils.isNotEmpty(comment)) {
                                            List<Integer> commentUserIds = comment.stream().map(ForumDynamicDO::getUserAccountId).collect(Collectors.toList());
                                            bUserAccountQO.setUserIds(commentUserIds);
                                            List<UserAccountSimpleDTO> commentUserAccountSimple =
                                                    userAppApi.feignListAppUserAccount1(bUserAccountQO);
                                            List<DynamicVO> commentAndReply = comment.stream().limit(2).map(ForumDynamicDO::buildDynamicVO).collect(Collectors.toList());
                                            for (DynamicVO vo : commentAndReply) {
                                                for (UserAccountSimpleDTO userAccountSimpleDTO : commentUserAccountSimple) {
                                                    if (vo.getUserAccountId().equals(userAccountSimpleDTO.getId())) {
                                                        UserBaseInfoVO userBaseInfoVO = new UserBaseInfoVO();
                                                        userBaseInfoVO.setUserImg(userAccountSimpleDTO.getUserImg());
                                                        userBaseInfoVO.setUserName(userAccountSimpleDTO.getUserName());
                                                        userBaseInfoVO.setNickName(userAccountSimpleDTO.getNickName());
                                                        userBaseInfoVO.setRegion(userAccountSimpleDTO.getRegion());
                                                        userBaseInfoVO.setIsPilot(userAccountSimpleDTO.getIsPilot());
                                                        vo.setUserBaseInfo(userBaseInfoVO);
                                                        break;
                                                    }
                                                }
                                            }
                                            dynamicVO.setCommentAndReplyVO(commentAndReply);
                                        }
                                    }
                                    UserAccountSimpleDTO userAccountSimpleDTO =
                                            userAccountInfoMap.get(d.getUserAccountId());
                                    if (userAccountSimpleDTO != null) {
                                        UserBaseInfoVO userBaseInfoVO = new UserBaseInfoVO();
                                        userBaseInfoVO.setNickName(userAccountSimpleDTO.getNickName());
                                        userBaseInfoVO.setUserImg(userAccountSimpleDTO.getUserImg());
                                        userBaseInfoVO.setRegion(userAccountSimpleDTO.getRegion());
                                        userBaseInfoVO.setIsPilot(userAccountSimpleDTO.getIsPilot());
                                        dynamicVO.setUserBaseInfo(userBaseInfoVO);
                                    }
                                    // 设置是否点赞
                                    for (ForumDynamicDO forumDynamicDO : forumDynamicDOS) {
                                        if (forumDynamicDO.getId().equals(d.getId())) {
                                            dynamicVO.setLikes(true);
                                            break;
                                        } else {
                                            dynamicVO.setLikes(false);
                                        }
                                    }
                                    return dynamicVO;
                                })
                        .collect(Collectors.toList());

        if (gambitId!=null){
            dynamicVOList = dynamicVOList.stream().filter(t -> t.getGambitName().size()!=0).collect(Collectors.toList());
            count = dynamicDao.countDynamic(gambitId);
        }

        for (DynamicVO dynamicVO : dynamicVOList) {
            Integer userAccountId = dynamicVO.getUserAccountId();
         int countAttention= gambitDao.selectCountAttentions(userAccountId,userId);
        // int countA=gambitDao.selectCountAttentions(userId,userAccountId);
            List<ForumAttentionDO> forumAttentionDOS=null;
            if(inUserId==null){
                forumAttentionDOS= gambitDao.selectAttentionCount(inUserId, userId);
            }else if (inUserId!=null){
                forumAttentionDOS= gambitDao.selectAttentionCount(userAccountId, userId);
            }
            if (countAttention!=0){
             dynamicVO.setStatus(true);
            }
            for (ForumAttentionDO forumAttentionDO : forumAttentionDOS) {
                if (forumAttentionDO!=null){
                    Integer userAccountId1 = dynamicVO.getUserAccountId();
                    if (userAccountId1.equals(userId)&& forumAttentionDO.getMutualAttention().equals(false)){
                        if (forumAttentionDO.getAttentionUserAccountId().equals(dynamicVO.getUserAccountId())||
                                        forumAttentionDO.getUserAccountId().equals(dynamicVO.getUserAccountId())
                        ){
                            dynamicVO.setStatus(true);
                        }
                    }
                    if (forumAttentionDO.getMutualAttention().equals(true)){
                        if (forumAttentionDO.getAttentionUserAccountId().equals(dynamicVO.getUserAccountId())||
                                forumAttentionDO.getUserAccountId().equals(dynamicVO.getUserAccountId())
                        ){
                            dynamicVO.setStatus(true);
                        }
                    }
                }
            }
            if (tokenUserId.equals(dynamicVO.getUserAccountId())){
                dynamicVO.setStatus(null);
            }
            if (inUserId!=null && inUserId.equals(dynamicVO.getUserAccountId())){
                dynamicVO.setStatus(null);
            }
        }

        // 帖子id 获取商品id
        List<DynamicVO> collect = dynamicVOList.stream().peek(item -> {
            Integer goodsId = item.getGoodsId();
            MallGoodsVO result = pmsAppApi.mallGoodsDetails(goodsId).getResult();
            item.setMallGoodsVO(result);
        }).collect(Collectors.toList());

        return PageResult.buildPage(pageNo, pageSize, count, collect);
    }
    @Override
    public ResultBody recentNewsList(Integer userAccountId) {
        List<ForumDynamicUserDO> forumDynamicDOS = dynamicDao.recentNewsList(userAccountId);
        for (ForumDynamicUserDO forumDynamicDO : forumDynamicDOS) {
            UserAccountVO info = info(forumDynamicDO.getUserAccountId());
            forumDynamicDO.setUserAccountVO(info);
        }
        return ResultBody.success(forumDynamicDOS);
    }

    @Override
    public PageResult appGambitList(ForumGambitQO forumGambitQO) {
        Integer pageNo = forumGambitQO.getPageNo();
        forumGambitQO.buildCurrentPage();
        int count =   dynamicDao.appGambitListCount(forumGambitQO);
        List<ForumGambitDO> forumGambitDOList= dynamicDao.appGambitList(forumGambitQO);
        List<ForumGambitDTO> collect = forumGambitDOList.stream().map(ForumGambitDO::buildForumGambitDTO).collect(Collectors.toList());
        return  PageResult.buildPage(pageNo, forumGambitQO.getPageSize(),count,collect);
    }

    /**
     *点赞或者取消
     * @param id
     * @param userAccountId
     * @param status
     * @return
     */
    @Override
    public ResultBody reviewLikes(Integer id, Integer userAccountId, Boolean status) {

        if (status.equals(true)){
            dynamicDao.updateLikeCountAdd(id);
            dynamicDao.insertReviewLikes(id,userAccountId);
        }else{
            dynamicDao.subtractLikeCount(id);
            dynamicDao.deleteReview(id,userAccountId);
        }
        return ResultBody.success();
    }

    @Override
    public PageResult postingLeaderboard(PostingLeaderboardQO postingLeaderboardQO) {
        Integer pageNo = postingLeaderboardQO.getPageNo();
        postingLeaderboardQO.buildCurrentPage();
        List<PostingLeaderboardDTO> postingLeaderboardDTOS = dynamicDao.postingLeaderboardCount(postingLeaderboardQO);
        for (PostingLeaderboardDTO postingLeaderboardDTO : postingLeaderboardDTOS) {
            UserAccountVO info = info(postingLeaderboardDTO.getUserAccountId());
            postingLeaderboardDTO.setUserAccountVO(info);
        }
        return  PageResult.buildPage(pageNo, postingLeaderboardQO.getPageSize(),postingLeaderboardDTOS.size(),postingLeaderboardDTOS);
    }

    @Override
    public List<ForumAttentionDO> getPilot(Integer userAccountId) {
        List<ForumAttentionDO> list = new ArrayList<>();
        List<ForumAttentionDO> forumAttentionDOS=dynamicDao.getPilot(userAccountId);
        for (ForumAttentionDO forumAttentionDO : forumAttentionDOS) {
            list.add(forumAttentionDO);
        }
        List<ForumAttentionDO> forumAttentionList=dynamicDao.getPilots(userAccountId);
        for (ForumAttentionDO forumAttentionDO : forumAttentionList) {
            list.add(forumAttentionDO);
        }
        List<ForumAttentionDO> collect = list.stream().distinct().collect(Collectors.toList());
        return collect;
    }


    public UserAccountVO info( Integer userAccountId) {
        String token = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(userAccountId.toString(), headers);
        ResponseEntity<String> exchange = restTemplate.exchange(userApp + "/userapp/user-account/interiorInfo?userAccountId=" + userAccountId , HttpMethod.GET, entity, String.class);
        Object body = exchange.getBody();
        JSONObject jsonObject = JSONObject.parseObject((String) body);
        JSONObject result1 = (JSONObject) jsonObject.get("result");
        UserAccountVO userAccountVO = JSON.parseObject(result1.toJSONString(), UserAccountVO.class);
        return userAccountVO;
    }


}
