package com.mmc.csf.release.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.config.IsNullConvertZeroUtil;
import com.mmc.csf.infomation.dto.*;
import com.mmc.csf.infomation.qo.ServiceOrderQO;
import com.mmc.csf.infomation.vo.RequireEveryStatusVO;
import com.mmc.csf.release.auth.dto.LoginSuccessDTO;
import com.mmc.csf.release.dao.BackRequirementsDao;
import com.mmc.csf.release.dao.OrderAmountDetailDao;
import com.mmc.csf.release.dao.RequirementsDao;
import com.mmc.csf.release.entity.requirements.OrderAmountDetailDO;
import com.mmc.csf.release.entity.requirements.RequirementsAmountUpdateDO;
import com.mmc.csf.release.entity.requirements.ServiceOrderFormDO;
import com.mmc.csf.release.entity.requirements.ServiceOrderFormDetailsDO;
import com.mmc.csf.release.enums.ServiceIdEnum;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.industry.IndustryTypeDTO;
import com.mmc.csf.release.service.BackRequirementsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/8/29 10:20
 * @Version 1.0
 */
@Service
@Transactional(rollbackFor = Exception.class)
@Slf4j
public class BackRequirementsServiceImpl implements BackRequirementsService {

    @Autowired
    private BackRequirementsDao backRequirementsDao;
    @Autowired
    private RequirementsDao requirementsDao;

    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private UserAppApi userAppApi;

    @Autowired
    private OrderAmountDetailDao orderAmountDetailDao;

    @Value("${iuav.pmsapp.url}")
    private String pmsApp;
    @Override
    public PageResult serviceOrderFormList(ServiceOrderQO param, LoginSuccessDTO userLoginInfoFromRedis) {

        //权限限制，除了admin以外其他飞手团队后台账号只能看到自己团队里面飞手发的订单
        Integer userAccountId = userLoginInfoFromRedis.getUserAccountId();
        List<Integer> pilotUserIdList = null;
        if(userAccountId != 1) {
            pilotUserIdList = userAppApi.feignGetPilotIdList(userLoginInfoFromRedis.getToken());
            if(pilotUserIdList == null || pilotUserIdList.isEmpty()) {
                return PageResult.buildPage(param.getPageNo(), param.getPageSize(), 0);
            }
            param.setPilotUserIdList(pilotUserIdList);
        }
        int count = backRequirementsDao.countService(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        log.info("{} 团队成员id === 》 {}",userAccountId, pilotUserIdList);
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<ServiceOrderFormDO> serviceOrderFormDOS = backRequirementsDao.serviceOrderFormList(param);
        List<ServiceOrderFormDTO> collect = serviceOrderFormDOS.stream().map(ServiceOrderFormDO::buildServiceOrderForm)
                .map(serviceOrderFormDTO -> {
                    Integer id = serviceOrderFormDTO.getId();
                    List<ServiceOrderFormDO> listSon = backRequirementsDao.getSonFromFatherRequireId(id);
                    //如果没有子订单 那就为总订单添加发单人和接单人信息
                    if(listSon == null || listSon.isEmpty()) {
                        //获取发单人信息
                        Integer userIdByRequireId = requirementsDao.getUserIdByRequireId(id);
                        UserBaseInfoDTO userBaseInfoDTO = userAppApi.feignGetUserBaseInfo(userIdByRequireId);
                        serviceOrderFormDTO.setOrderRelease(userBaseInfoDTO);
                        //获取接单人信息
                        Integer pilotUserIdByRequireId = requirementsDao.getPilotUserIdByRequireId(id);
                        if (pilotUserIdByRequireId == null) {
                            serviceOrderFormDTO.setOrderReceive(null);
                        }else {
                            UserBaseInfoDTO pilotUserBaseInfoDTO = userAppApi.feignGetUserBaseInfo(pilotUserIdByRequireId);
                            serviceOrderFormDTO.setOrderReceive(pilotUserBaseInfoDTO);
                        }
                        return serviceOrderFormDTO;
                    }
                    List<ServiceOrderFormDTO> childrenList = listSon.stream().map(ServiceOrderFormDO::buildServiceOrderForm).
                            map(serviceOrderFormDTO1 -> {
                                //获取发单人信息
                                Integer userIdByRequireId = requirementsDao.getUserIdByRequireId(serviceOrderFormDTO1.getId());
                                UserBaseInfoDTO userBaseInfoDTO = userAppApi.feignGetUserBaseInfo(userIdByRequireId);
                                serviceOrderFormDTO1.setOrderRelease(userBaseInfoDTO);
                                //获取接单人信息
                                Integer pilotUserIdByRequireId = requirementsDao.getPilotUserIdByRequireId(serviceOrderFormDTO1.getId());
                                if (pilotUserIdByRequireId == null) {
                                    serviceOrderFormDTO1.setOrderReceive(null);
                                }else {
                                    UserBaseInfoDTO pilotUserBaseInfoDTO = userAppApi.feignGetUserBaseInfo(pilotUserIdByRequireId);
                                    serviceOrderFormDTO1.setOrderReceive(pilotUserBaseInfoDTO);
                                }
                                return serviceOrderFormDTO1;
                            }).
                            collect(Collectors.toList());
                    serviceOrderFormDTO.setChildrenRequire(childrenList);
                    return serviceOrderFormDTO;
                })
                .collect(Collectors.toList());
        return PageResult.buildPage(pageNo, param.getPageSize(), count, collect);
    }


    @Override
    public ResultBody serviceOrderFormDetails(Integer requirementsInfoId, LoginSuccessDTO userLoginInfoFromRedis) {

        RequireEveryStatusVO requireEveryStatusVO = new RequireEveryStatusVO();
        //抵达现场
        ServiceArriveSceneDTO arriveSceneDTO = requirementsDao.serviceArriveSceneDTO(requirementsInfoId);
        requireEveryStatusVO.setServiceArriveSceneDTO(arriveSceneDTO);
        //完成任务
        ServiceFulfilATaskDTO fulfilATaskDTO = requirementsDao.serviceFulfilATaskDTO(requirementsInfoId);
        requireEveryStatusVO.setServiceFulfilATaskDTO(fulfilATaskDTO);
        //评价
        ServiceEvaluateDTO serviceEvaluateDTO = requirementsDao.serviceEvaluateDTO(requirementsInfoId);
        requireEveryStatusVO.setServiceEvaluateDTO(serviceEvaluateDTO);
        //修改金额
        RequirementsAmountUpdateDTO requirementsAmountUpdateDTO = requirementsDao.amountUpdateDTO(requirementsInfoId);
        requireEveryStatusVO.setAmountUpdate(requirementsAmountUpdateDTO);

        //获取发单人信息
        Integer userIdByRequireId = requirementsDao.getUserIdByRequireId(requirementsInfoId);
        UserBaseInfoDTO userBaseInfoDTO = userAppApi.feignGetUserBaseInfo(userIdByRequireId);
        requireEveryStatusVO.setOrderRelease(userBaseInfoDTO);
        //获取接单人信息
        Integer pilotUserIdByRequireId = requirementsDao.getPilotUserIdByRequireId(requirementsInfoId);
        if (pilotUserIdByRequireId == null) {
            requireEveryStatusVO.setOrderReceive(null);
        }else {
            UserBaseInfoDTO pilotUserBaseInfoDTO = userAppApi.feignGetUserBaseInfo(pilotUserIdByRequireId);
            requireEveryStatusVO.setOrderReceive(pilotUserBaseInfoDTO);
        }
        ServiceOrderFormDetailsDO orderFormDetailsDO = backRequirementsDao.serviceOrderFormDetails(requirementsInfoId);
        ServiceOrderFormDetailsDTO serviceOrderFormDetailsDTO = orderFormDetailsDO.buildOrderFormDetails();

        IndustryTypeDTO industryTypeDTO = getIndustryTypeById(serviceOrderFormDetailsDTO.getServiceId(),serviceOrderFormDetailsDTO.getInspectionId());

        serviceOrderFormDetailsDTO.setInspectionName(industryTypeDTO.getInspectionName());

        IsNullConvertZeroUtil.checkIsNull(serviceOrderFormDetailsDTO);

        requireEveryStatusVO.setServiceOrderFormDetailsDTO(serviceOrderFormDetailsDTO);

        return ResultBody.success(requireEveryStatusVO);
    }

    @Override
    public ResultBody getOrderAmountDetails(Integer requirementsInfoId) {
        return ResultBody.success(orderAmountDetailDao.selectByPrimaryKey(requirementsInfoId));
    }

    @Override
    public ResultBody updateOrderAmountDetails(List<OrderAmountDetailDO> list) {
        Integer requirementsInfoId = list.get(0).getRequirementsInfoId();
        if(requirementsInfoId == null) {
            return ResultBody.error("订单id不能为空");
        }
        //判当前订单是否是完成任务的状态
        if(!Objects.equals(requirementsDao.selectServiceIdByRequireId(requirementsInfoId), ServiceIdEnum.DETAIL_COMPLETE.getCode())) {
            return ResultBody.error("当前订单不能进行修改金额");
        }
        //修改当前订单的状态
        requirementsDao.updateScene(requirementsInfoId, ServiceIdEnum.WAIT_CHANGE_AMOUNT.getCode());
        requirementsDao.updateInfo(requirementsInfoId, ServiceIdEnum.WAIT_CHANGE_AMOUNT.getCode());
        //删除掉默认的一条数据
        orderAmountDetailDao.deleteByPrimaryKey(requirementsInfoId);
        //把后面用户添加的数据保存到数据库
        orderAmountDetailDao.batchInsert(list);

        //算一下总金额保存下来，然后去小程序支付
        BigDecimal amountSum = new BigDecimal(0);
        for(OrderAmountDetailDO orderAmountDetailDO : list) {
            amountSum = amountSum.add(orderAmountDetailDO.getRealWages());
        }
        RequirementsAmountUpdateDO requirementsAmountUpdateDO = new RequirementsAmountUpdateDO();
        requirementsAmountUpdateDO.setRequirementsInfoId(requirementsInfoId);
        requirementsAmountUpdateDO.setUpdateOrderAmount(amountSum);
        requirementsAmountUpdateDO.setUserSureChange(0);
        requirementsDao.requirementsAmountUpdate(requirementsAmountUpdateDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody insertOrderAmountDetails(List<OrderAmountDetailDO> list) {
        orderAmountDetailDao.batchInsert(list);
        return ResultBody.success();
    }

    public IndustryTypeDTO getIndustryTypeById(Integer serviceId, Integer inspectionId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        String url = null;
        if(inspectionId!=null){
            url = String.format("%s/pms/industry/getIndustryTypeById?id=%s&inspectionId=%s", pmsApp, serviceId, inspectionId);
        }else {
            url = String.format("%s/pms/industry/getIndustryTypeById?id=%s", pmsApp, serviceId);
        }
        ResponseEntity<String> exchange = restTemplate.exchange(url, HttpMethod.GET, entity, String.class);
        String body = exchange.getBody();
        IndustryTypeDTO industryTypeDTO = JSONObject.parseObject(body, IndustryTypeDTO.class);
        return industryTypeDTO;
    }
}
