package com.mmc.csf.release.entity.information;

import com.mmc.csf.infomation.vo.IndustryCaseVO;
import com.mmc.csf.infomation.vo.PersonSendOrderVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author han
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PersonSendOrderDO implements Serializable {
    private static final long serialVersionUID = 1L;

    private  Integer id;
    /**
     * 服务需求订单id
     */
    private Integer requirementsInfoId;
    /**
     * 派单飞手id
     */
    private Integer pilotCertificationId;
    /**
     * 派单飞手用户id
     */
    private Integer pilotCertificationUserId;
    /**
     * 派单飞手用户id
     */
    private Integer teamId;
    /**
     * 派单飞手用户id
     */
    private Integer teamUserId;

    /**
     * 创建时间
     */
    private Date createTime;

    public PersonSendOrderDO(PersonSendOrderVO personSendOrderVO){
        this.requirementsInfoId = personSendOrderVO.getRequirementsInfoId();
        this.pilotCertificationId = personSendOrderVO.getPilotCertificationId();
        this.pilotCertificationUserId = personSendOrderVO.getPilotCertificationUserId();
    }
}
