package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.ServiceOrderFormDTO;
import com.mmc.csf.infomation.qo.ServiceOrderQO;
import com.mmc.csf.infomation.vo.RequireEveryStatusVO;
import com.mmc.csf.release.entity.requirements.OrderAmountDetailDO;
import com.mmc.csf.release.model.group.Page;
import com.mmc.csf.release.service.BackRequirementsService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @Author small
 * @Date 2023/8/29 10:18
 * @Version 1.0
 */
@Api(tags = {"服务需求订单后台相关"})
@RestController
@RequestMapping("/backRequirements/")
public class BackRequirementsController extends BaseController {
    @Autowired
    private BackRequirementsService backRequirementsService;

    @ApiOperation(value = "后台管理——服务订单分页")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ServiceOrderFormDTO.class)})
    @PostMapping("serviceOrderFormList")
    public ResultBody<ServiceOrderFormDTO> serviceOrderFormList(HttpServletRequest request,
                                                                @Validated(value = {Page.class}) @ApiParam(value = "角色查询QO", required = true) @RequestBody ServiceOrderQO param) {
        return ResultBody.success(backRequirementsService.serviceOrderFormList(param, this.getUserLoginInfoFromRedis(request)));
    }


    @ApiOperation(value = "后台管理——服务订单详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RequireEveryStatusVO.class)})
    @GetMapping("serviceOrderFormDetails")
    public ResultBody<RequireEveryStatusVO> serviceOrderFormDetails(HttpServletRequest request, @ApiParam(value = "需求发布id", required = true) @RequestParam Integer requirementsInfoId) {
        return backRequirementsService.serviceOrderFormDetails(requirementsInfoId, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "后台管理——订单金额明细")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("getOrderAmountDetails")
    public ResultBody getOrderAmountDetails( @ApiParam(value = "需求发布id", required = true) @RequestParam Integer requirementsInfoId) {
        return backRequirementsService.getOrderAmountDetails(requirementsInfoId);
    }

    @ApiOperation(value = "后台订单——修改金额明细")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updateOrderAmountDetails")
    public ResultBody updateOrderAmountDetails(@RequestBody List<OrderAmountDetailDO> list) {
        return backRequirementsService.updateOrderAmountDetails(list);
    }

    @ApiOperation(value = "后台订单——新增金额明细")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insertOrderAmountDetails")
    public ResultBody insertOrderAmountDetails(@RequestBody List<OrderAmountDetailDO> list) {
        return backRequirementsService.insertOrderAmountDetails(list);
    }

}
