package com.mmc.csf.release.entity;

import com.mmc.csf.release.task.vo.TaskServiceDetailVO;
import com.mmc.csf.release.task.vo.TaskServiceVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;
import java.io.Serializable;

/**
 * 巡检管理(InspectionDO)实体类
 *
 * @author makejava
 * @since 2023-05-17 17:36:15
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class InspectionDO implements Serializable {
    private static final long serialVersionUID = 735206174138687828L;

    private Integer id;
    /**
     * 服务名称
     */
    private String name;
    /**
     * 服务亮点
     */
    private String lightSpot;
    /**
     * 0飞行服务，1个人服务，2设备售卖，3设备租赁，4设备返祖
     */
    private Integer serviceType;
    /**
     * 视频地址
     */
    private String video;
    /**
     * 是否限时活动
     */
    private Integer limitActive;
    /**
     * 作业类型
     */
    private Integer workTypeId;

    private Date updateTime;

    private Date addTime;
    /**
     * 是否删除  0 未删除  1 删除
     */
    private Integer isDel;

    private String number;

    private Integer sort;
    /**
     * 图片地址
     */
    private String image;
    /**
     * 上架1 下架0
     */
    private Integer isShelf;
    /**
     * 富文本内容
     */
    private String content;
    /**
     * 服务领取数量（下单数量）
     */
    private Integer orderNum;
    /**
     * 小卡片地址
     */
    private String cardImg;
    /**
     * 手动设置领取服务数量
     */
    private Integer fakeNum;
    /**
     * 服务编码
     */
    private Integer isShowCode;
    /**
     * 是否用于生成假定单
     */
    private Integer isFake;
    /**
     * 应用标签
     */
    private Integer appTypeId;
    /**
     * 供应商的id
     */
    private Integer supplierId;
    /**
     * 价格
     */
    private BigDecimal price;

    public TaskServiceVO buildTaskService() {
        return TaskServiceVO.builder().serviceName(name).teamName("浙江科比特创新科技有限公司").price(price).id(id).build();
    }

    public TaskServiceDetailVO buildTaskServiceDetailVO(){
        return TaskServiceDetailVO.builder().serviceName(name).id(id).teamPoster("https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/d755a2ee-ffe4-4c2c-8a8b-afcf447ad2ac.jpg")
                .pictureUrl(image).videoUrl(video).build();
    }
}

