package com.mmc.csf.release.entity;

import com.mmc.csf.release.task.vo.EvaluateInfoVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.io.Serializable;

/**
 * 评论表(InspComtDO)实体类
 *
 * @author makejava
 * @since 2023-05-18 14:32:05
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class InspComtDO implements Serializable {
    private static final long serialVersionUID = 296479156881845974L;
    
    private Integer id;
    /**
     * 头像
     */
    private String userImg;
    /**
     * 昵称
     */
    private String nickName;
    /**
     * 评价内容
     */
    private String content;
    /**
     * 评价图片集合"1.jpg,2.jpg"使用逗号隔开
     */
    private String contentImgs;
    /**
     * 评价视频
     */
    private String contentVideo;
    /**
     * 评价星级
     */
    private Integer star;
    /**
     * 关键字集合"深圳市,广州市,长沙市,"使用逗号隔开
     */
    private String tags;
    /**
     * 是否带图 0：带图 1：不带图
     */
    private Integer isImg;
    /**
     * 评价类型：0：好评 1：差评
     */
    private Integer type;
    /**
     * 创建时间
     */
    private Date createTime;

    public EvaluateInfoVO buildEvaluateInfoVO() {
        return EvaluateInfoVO.builder()
                .id(this.id)
                .content(this.content)
                .contentImgs(this.contentImgs)
                .contentVideo(this.contentVideo)
                .star(this.star)
                .type(this.type)
                .build();
    }

}

