package com.mmc.csf.release.dao;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.entity.*;
import com.mmc.csf.release.task.qo.TaskServiceQo;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @Author LW
 * @date 2023/5/17 13:56
 * 概要：
 */
@Mapper
public interface TaskDao {
    /**
     * 计算任务服务列表
     *
     * @param taskServiceQo 任务服务
     * @return int
     */
    int countTaskServiceList(TaskServiceQo taskServiceQo);

    /**
     * 列表页面任务服务
     *
     * @param taskServiceQo 任务服务
     * @return {@link List}<{@link InspectionDO}>
     */
    List<InspectionDO> listPageTaskService(TaskServiceQo taskServiceQo);

    /**
     * 查询服务详情
     *
     * @param id id
     * @return {@link InspectionDO}
     */
    InspectionDO selectInspectionById(Integer id);

    /**
     * 得到行业和检查
     *
     * @param industryId   行业id
     * @param inspectionId 检查id
     * @return {@link Integer}
     */
    Integer getIndustryAndInspect(Integer industryId, Integer inspectionId);

    /**
     * 通过id获取检验
     *
     * @param inspectionId 检查身份证
     * @return {@link InspectionDO}
     */
    InspectionDO getInspectionById(Integer inspectionId);

    /**
     * 插入订单任务
     *
     * @param taskOrderDo 任务订单做
     */
    void insertOrderTask(TaskOrderDO taskOrderDo);

    /**
     * 得到评估信息列表
     *
     * @param size 大小
     * @return {@link List}<{@link InspComtDO}>
     */
    List<InspComtDO> getEvaluateInfoList(int size);

    /**
     * 获取所有行业信息
     */
    List<IndustryDO> listAllIndustry();

    /**
     * 列出所有应用程序类型
     *
     * @return {@link List}<{@link AppTypeDO}>
     */
    List<AppTypeDO> listAllAppType();

    /**
     * 列出所有任务服务
     *
     * @return {@link List}<{@link InspectionDO}>
     */
    List<InspectionDO> listAllTaskService();
}
