package com.mmc.csf.release.dao;

import com.mmc.csf.release.entity.ForumDynamicDO;
import com.mmc.csf.release.entity.ForumImageDO;
import com.mmc.csf.release.entity.ForumVideoDO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author LW
 * @date 2023/5/15 10:29
 * 概要：动态信息数据访问层
 */
@Mapper
public interface DynamicDAO {

    /**
     * 插入动态
     *
     * @param forumDynamicDO 论坛动态信息
     * @return {@link ForumDynamicDO}
     */
    void insertDynamic(ForumDynamicDO forumDynamicDO);

    /**
     * 插入图片
     *
     * @param dynamicId 动态id
     * @param url       url
     */
    void insertPicture(@Param("dynamicId") Integer dynamicId, @Param("url") String url);

    /**
     * 插入视频
     *
     * @param dynamicId 动态id
     * @param videoUrl  视频网址
     */
    void insertVideo(@Param("dynamicId") Integer dynamicId, @Param("videoUrl") String videoUrl);

    /**
     * 更新动态点赞数量
     *
     * @param dynamicId 动态id
     * @param pid       pid
     */
    void updateDynamicLikeCount(@Param("dynamicId") Integer dynamicId, @Param("pid") Integer pid);

    /**
     * 得到动态信息
     *
     * @param dynamicId 动态id
     * @return {@link ForumDynamicDO}
     */
    ForumDynamicDO getDynamicInfo(Integer dynamicId);

    /**
     * 动态点赞数减
     *
     * @param dynamicId 动态id
     * @param pid       pid
     */
    void updateSubDynamicLikeCount(Integer dynamicId, Integer pid);

    /**
     * 更新动态评论数
     *
     * @param dynamicId 动态id
     * @param pid       pid
     */
    void updateDynamicCommentCount(Integer dynamicId, Integer pid);

    /**
     * 动态列表计数
     *
     * @return int
     */
    int countDynamicList();

    /**
     * 动态列表
     *
     * @param itemIndex 项指数
     * @param pageSize  页面大小
     * @return {@link List}<{@link ForumDynamicDO}>
     */
    List<ForumDynamicDO> dynamicList(int itemIndex, Integer pageSize);

    /**
     * 列表动态图片
     *
     * @param ids id
     * @return {@link List}<{@link ForumImageDO}>
     */
    List<ForumImageDO> listDynamicPicture(List<Integer> ids);

    /**
     * 动态视频列表
     *
     * @param ids id
     * @return {@link List}<{@link ForumVideoDO}>
     */
    List<ForumVideoDO> listDynamicVideo(List<Integer> ids);
}
