package com.mmc.csf.release.flyer.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author LW
 * @date 2023/5/17 14:28
 * 概要:课程信息
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CurriculumInfoVO implements Serializable {
    @ApiModelProperty(value = "课程id")
    private Integer id;

    @ApiModelProperty(value = "价格")
    private BigDecimal price;

    @ApiModelProperty(value = "供应商名称")
    private String supplierName;

    @ApiModelProperty(value = "课程名称")
    private String curriculumName;

    @ApiModelProperty(value = "课程是否免费 0：免费 1：付费")
    private Integer free;

    @ApiModelProperty(value = "课程介绍")
    private String curriculumDesc;

    @ApiModelProperty(value = "课程视频")
    private String videoUrl;
}
