package com.mmc.csf.release.entity.forum;

import com.mmc.csf.release.forum.vo.MediaVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 动态图片表(ForumResourceDO)实体类
 *
 * @author lw
 * @since 2023-05-16 09:57:50
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ForumResourceDO implements Serializable {
  private static final long serialVersionUID = 678578415154893126L;
  /** 动态ID，必填 */
  private Integer dynamicId;
  /** 图片URL，必填 */
  private String resourceUrl;
  /** 创建时间 */
  private Date createTime;
  /** 修改时间 */
  private Date updateTime;
  /** 类型 */
  private Integer type;

  public MediaVO buildMedia() {
    return MediaVO.builder().type(type).url(resourceUrl).build();
  }
}
