package com.mmc.csf.release.entity.curriculum;

import com.mmc.csf.release.flyer.vo.RegistrationVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;
import java.io.Serializable;

/**
 * 飞手报名信息表(PilotRegistrationDO)表实体类
 *
 * @author makejava
 * @since 2023-05-15 14:13:43
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class PilotRegistrationDO implements Serializable {

    private static final long serialVersionUID = -1914453807497409611L;
    private Integer id;
    @ApiModelProperty(value = "申请用户id")
    private Integer applyUserId;
    @ApiModelProperty(value = "姓名")
    private String name;
    @ApiModelProperty(value = "城市")
    private Integer city;
    @ApiModelProperty(value = "手机号")
    private String telephone;
    @ApiModelProperty(value = "是否有驾照 0：是 1：否")
    private Integer drivingLicense;
    @ApiModelProperty(value = "省份")
    private Integer province;
    @ApiModelProperty(value = "无人机驾驶员执照一级分类id")
    private Integer uavLicenseLevelOne;
    @ApiModelProperty(value = "无人机驾驶员执照二级分类id")
    private Integer uavLicenseLevelTwo;
    @ApiModelProperty(value = "无人机驾驶员执照三级分类id")
    private Integer uavLicenseLevelThree;
    @ApiModelProperty(value = "行业应用认证")
    private String industryAppAuth;
    @ApiModelProperty(value = "备注")
    private String remark;
    private Date createTime;
    private Date updateTime;
    private Integer deleted;

    public PilotRegistrationDO(RegistrationVO registrationVO) {
        this.name = registrationVO.getName();
        this.city = registrationVO.getCity();
        this.telephone = registrationVO.getTelephone();
        this.drivingLicense = registrationVO.getDrivingLicense();
        this.province = registrationVO.getProvince();
        this.uavLicenseLevelOne = registrationVO.getUavLicenseLevelOne();
        this.uavLicenseLevelTwo = registrationVO.getUavLicenseLevelTwo();
        this.uavLicenseLevelThree = registrationVO.getUavLicenseLevelThree();
        this.remark = registrationVO.getRemark();
    }
}

